{$A+,B-,D-,E-,F+,G-,I-,L-,N-,O-,R-,S-,V+,X+}

UNIT GPRI;

{ Unit zum Erstellen von GPRI-Programmen fr GP in Turbo Pascal ((C) Borland International Inc.) }
{ Erstellt von Ulf Saran, DH1DAE 1992, letzte nderung 28.09.1993                                }
{ Es wird mindestens Version 6.0 bentigt, Borland Pascal 7.0 wurde noch nicht getestet          }
{ Diese Unit darf nach eigenen Wnschen verndert werden, sofern die nderungen im Sourcecode    }
{ durch Kommentare deutlich gemacht werden.                                                      }


Interface

TYPE
  Str80 = String[80];

  TaskType = RECORD        { Datenstruktur zur bergabe der Sprungadressen }
    PrefixSegment :  Word; { Prfix-Segment des Remote-Programms           }
    InitPtr,               { Zeiger auf die Init-Routine                   }
    RXPtr,                 { Zeiger auf die Empfangs-Routine               }
    StrategiePtr,          { Zeiger auf die Strategie-Routine              }
    ExitPtr :  Pointer;    { Zeiger auf die Exit-Routine                   }
  END;

  QSODataType = RECORD     { Datenstruktur zur Ermittlung der QSO-Daten    }
                  MyCall,
                  Call     :  String[9];
                  Name     :  Str80;
                  Pfad     :  String;
                END;



FUNCTION TaskInit (InitPr,RXPr,StrategiePr,ExitPr : Pointer) : Boolean;
FUNCTION InstallTXHandler (TXPr : Pointer) : Boolean;
FUNCTION InstallGPRIMessageHandler (GPRIMPr : Pointer) : Boolean;
FUNCTION Send (S : String; Mode : Byte; Macro : Boolean) : Boolean;
PROCEDURE SendString (S : String);
PROCEDURE SendMacroString (S : String);
FUNCTION StartFileTransfer (Mode : Byte; FName : Str80) : Boolean;
PROCEDURE SendGPRIMessage (Ident : Word; VAR Data);
PROCEDURE DisconnectChannel;
PROCEDURE GetQSOData (VAR QSO : QSODataType);


CONST
  { Konstanten fr das Mode-Byte beim Senden eines Strings zu GP }
  DefaultMode    = 0;    { Text aussenden, Echo ausgeben, Sendepuffer nicht sofort leeren }
  Flush          = 1;    { Sendepuffer sofort leeren }
  TXOnly         = 2;    { Text nur aussenden, aber kein Echo im RX-Fenster }
  EchoOnly       = 4;    { Text nur im RX-Fenster anzeigen, jedoch nicht aussenden }

                         { Ein Echo wird generell nur angezeigt, wenn es bei GP eingeschaltet ist }

  Macro          = TRUE;
  NoMacro        = FALSE;


  GPRI_VersionHi : Byte = 1;
  GPRI_VersionLo : Byte = 0;
  ProgrammEnde   : Boolean = FALSE; { Programmende-Flag.  }
                                    { TRUE :  GP soll Programm beenden }
                                    { FALSE :  Programm soll weiterlaufen }

VAR
  InitPointer,
  StrategiePointer,
  ExitPointer,
  GPRIMessagePointer,
  TXPointer,
  RXPointer        :  Pointer;
  Handle           :  Byte;    { Handle-Nummer des GPRI-Programms }


Implementation 


VAR
  TaskData   : TaskType;
  SendPtr,              { Pointer auf Sende-Routine von GP }
  GetDataPtr,           { Pointer auf die QSO_Daten-Routine von GP }
  GPRIMessagePtr,       { Pointer auf die GPRI-Message-Routine von GP }
  DisconPtr,            { Pointer auf die Disconnect-Routine von GP }
  FTransfPtr : Pointer; { Pointer auf die Filetransfer-Routine von GP }




PROCEDURE InitProc; Assembler; { Initialisierungs-Procedure, wird nur }
                               { einmal beim Programmstart aufgerufen }
ASM
  MOV AX,SEG @DATA { Datensegment umschalten }
  MOV DS,AX
  CALL InitPointer { User-Routine aufrufen }
  MOV BL,ProgrammEnde { Programmende-Flag an GP bergeben }
END;



PROCEDURE RXProc; Assembler; { Empfangs-Procedure.  Wird von GP }
                             { aufgerufen, wenn Daten empfangen wurden }
ASM
  MOV AX,SEG @DATA { Datensegment umschalten }
  MOV DS,AX
  PUSH ES { Umwandlung des Zeigers ES:DX in eine TP- }
  PUSH DX { Stringbergabe.  ES:BX -> Empfangsdaten }
  CALL RXPointer { User-Routine aufrufen }
  MOV BL,ProgrammEnde { Programmende-Flag an GP bergeben }
END;



PROCEDURE TXProc; Assembler;     { Sende-Procedure.  Wird von GP aufgerufen,  }
                                 { wenn Daten auf der Tastatur eingegeben und }
                                 { gesendet werden sollen.                    }
ASM
  MOV AX,SEG @DATA { Datensegment umschalten }
  MOV DS,AX
  PUSH ES { Umwandlung des Zeigers ES:DX in eine TP- }
  PUSH DX { Stringbergabe.  ES:BX -> Sendedaten }
  CALL TXPointer   { User-Routine aufrufen }
  MOV BL,ProgrammEnde { Programmende-Flag an GP bergeben }
END;



PROCEDURE StrategieProc; Assembler; { "Strategie-Routine".  Wird von GP }
                                    { periodisch aufgerufen }
ASM
  MOV AX,SEG @DATA { Datensegment umschalten }
  MOV DS,AX
  CALL StrategiePointer { User-Routine aufrufen }
  MOV BL,ProgrammEnde { Programmende-Flag an GP bergeben }
END;


PROCEDURE ExitProc; Assembler; { Exit-Routine.  Wird von GP vor der }
                               { Beendigung des Programms aufgerufen }
ASM
  MOV AX,SEG @DATA { Datensegment umschalten }
  MOV DS,AX
  CALL ExitPointer { User-Routine aufrufen }
END;



PROCEDURE GetGPRIMessage; Assembler;

ASM
  MOV  AX,SEG @DATA
  MOV  DS,AX
  PUSH CX
  PUSH ES
  PUSH DX
  CALL GPRIMessagePointer
END;



FUNCTION Send (S : String; Mode : Byte; Macro : Boolean) : Boolean; Assembler;
{ Sendet einen String zu GP }

ASM
  LES DX,S      { Zeiger ES:DX auf String S erzeugen }
  MOV BX,DX
  MOV BH,Mode   { Sende-Modus }
  MOV BL,Handle { Handle-Nummer ins BL-Register }
  MOV CL,Macro  { Macro-Flag }
  CALL SendPtr  { GP-Routine aufrufen }
END;



PROCEDURE SendString (S : String);
{ Sendet einen String auf dem connecteten Kanal aus (ohne Makroauswertung) }

VAR
  Mode   : Byte;

BEGIN
  IF S[0] = #0 THEN Exit;   { Wenn Leerstring, dann Routine sofort beenden }
  IF S[Byte(S[0])] = #13 THEN
    Mode := 0
  ELSE
    Mode := Flush;
  Send(S,Mode,NoMacro);
END;




PROCEDURE SendMacroString (S :  String);
{ Sendet einen String auf dem connecteten Kanal aus (mit Makroauswertung) }

VAR
  Mode   : Byte;

BEGIN
  IF S[0] = #0 THEN Exit;   { Wenn Leerstring, dann Routine sofort beenden }
  IF S[Byte(S[0])] = #13 THEN
    Mode := 0
  ELSE
    Mode := Flush;
  Send(S,Mode,Macro);
END;




FUNCTION StartFileTransfer (Mode :  Byte; FName :  Str80) : Boolean; Assembler;
{ Startet einen Filetransfer auf dem connecteten Kanal. }
{ FName :  Dateiname (kompletter Pfad)                  }
{ Mode  :  0 = Textdatei                                }
{          1 = Binrmodus (kein AutoBin)                }
{          2 = AutoBin-Modus                            }

ASM
  LES DX,FName    { Zeiger ES:DX auf String FName erzeugen }
  MOV BL,Handle   { Handlenummer ins BL-Register }
  MOV BH,Mode     { Modusnummer ins BH-Register }
  CALL FTransfPtr { GP-Routine aufrufen }
END;



PROCEDURE SendGPRIMessage (Ident : Word; VAR Data); Assembler;
{ Sendet eine Nachricht an andere GPRI-Programme }
{ Ident : Identifikationsnummer                  }
{ Data  : Datenstruktur (beliebig)               }

ASM
  PUSH DS
  LES  DX,Data
  MOV  BL,Handle
  MOV  CX,Ident
  CALL GPRIMessagePtr
  POP  DS
END;




PROCEDURE DisconnectChannel; Assembler;
{ Disconnected den Kanal, das GPRI-Programm wird dabei automatisch }
{ beendet.                                                         }

ASM
  MOV  BL,Handle
  CALL DisconPtr { GP-Routine aufrufen }
END;



PROCEDURE GetQSOData (VAR QSO :  QSODataType); Assembler;
{ Liefert verschiedene Daten ber das QSO zurck                          }
{ Die Datenstruktur ist im Variablentyp "QSODataType" festgelegt und darf }
{ nicht gendert werden.                                                  }

ASM
  LES DX,QSO      { Zeiger ES:DX auf Variable QSO erzeugen }
  MOV BL,Handle   { Handle-Nummer ins BL-Register }
  CALL GetDataPtr { GP-Routine aufrufen }
END;



FUNCTION InstallTXHandler (TXPr : Pointer) : Boolean;

VAR
  TXPtr    : Pointer;

BEGIN
  IF TXPr <> NIL THEN BEGIN
    TXPointer := TXPr;
    TXPtr := @TXProc;
    ASM
      MOV  AX,$DF04        { Set TX entry point }
      LES  BX,TXPtr
      INT  $2F
      CMP  AX,$4750
      JNE  @Fehler
      MOV  @Result,1
      JMP  @Ende
     @Fehler:
      MOV  @Result,0
     @Ende:
    END;
  END ELSE
    InstallTXHandler := FALSE;
END;



FUNCTION InstallGPRIMessageHandler (GPRIMPr : Pointer) : Boolean;

VAR
  MessagePtr   : Pointer;

BEGIN
  IF GPRIMPr <> NIL THEN BEGIN
    GPRIMessagePointer := GPRIMPr;
    MessagePtr := @GetGPRIMessage;
    ASM
      MOV  AX,$DF03        { Exchange GPRI Message Vectors }
      LES  BX,MessagePtr
      INT  $2F
      CMP  AX,$4750
      JNE  @Fehler
      MOV  WORD PTR [GPRIMessagePtr+2],ES
      MOV  WORD PTR [GPRIMessagePtr+0],BX
      MOV  @Result,1
      JMP  @Ende
     @Fehler:
      MOV  @Result,0
     @Ende:
    END;
  END ELSE
    InstallGPRIMessageHandler := FALSE;
END;




FUNCTION TaskInit (InitPr,RXPr,StrategiePr,ExitPr :  Pointer) :  Boolean;
{ Prft, ob GPRI installiert ist und tauscht dann die Adressen der }
{ verschiedenen Routinen mit GP aus.                               }
{ Ausgabe:  TRUE = Programm erfolgreich installiert                }
{ FALSE = GPRI nicht installiert                                   }

BEGIN
  RXPointer := RXPr;
  InitPointer := InitPr;
  StrategiePointer := StrategiePr;
  ExitPointer := ExitPr;
  WITH TaskData DO BEGIN
    PrefixSegment := PrefixSeg;
    IF InitPr <> NIL THEN InitPtr := @InitProc;
    IF RXPr <> NIL THEN RXPtr := @RXProc;
    IF StrategiePr <> NIL THEN StrategiePtr := @StrategieProc;
    IF ExitPr <> NIL THEN ExitPtr := @ExitProc;
  END;
  ASM
    MOV AX,$DFFF    { Get Version Number }
    INT $2F
    CMP AX,$4750    { Ist AX = 4750h? }
    JNE @Fehler     { Wenn Nein -> Fehler }
    MOV GPRI_VersionHi,BH
    MOV GPRI_VersionLo,BL

    MOV AX,$DF02    { Get QSO Data Procedure Pointer }
    INT $2F
    MOV WORD PTR [GetDataPtr+2],ES
    MOV WORD PTR [GetDataPtr],BX
    CMP AX,$4750    { Ist AX = 4750h?  }
    JNE @Fehler     { Wenn Nein -> Fehler }

    MOV AX,DS              { Datensegment ins ES-Register...              }
    MOV ES,AX
    MOV BX,OFFSET TaskData { ...und Offset ins BX-Register, fertig ist    }
                           { der Zeiger ES:BX auf die Variable "TaskData" }
    MOV AX,$DF00           { Register as Remote Program}
    INT $2F                { Interrupt 2Fh aufrufen }
    MOV WORD PTR [SendPtr+2],ES { Zeiger "SendPtr" mit ES:DX laden }
    MOV WORD PTR [SendPtr],BX
    MOV Handle,CL   { CL-Register in Variable "Handle" schreiben }
    CMP AX,$4750    { Ist AX = 4750h? }
    JNE @Fehler     { Wenn Nein -> Fehler }

    MOV AX,$DF01    { Get Filetransfer Procedure Pointer }
    INT $2F { Interrupt 2Fh aufrufen }
    MOV WORD PTR [FTransfPtr+2],ES { Zeiger "FTransfPtr" mit ES:BX laden }
    MOV WORD PTR [FTransfPtr],BX
    CMP AX,$4750                   { Ist AX = 4750h?  }
    JNE @Fehler     { Wenn Nein -> Fehler }

    MOV AX,$DF05    { Get Disconnect Procedure Pointer }
    INT $2F { Interrupt 2Fh aufrufen }
    MOV WORD PTR [DisconPtr+2],ES  { Zeiger "FTransfPtr" mit ES:BX laden }
    MOV WORD PTR [DisconPtr],BX
    CMP AX,$4750                   { Ist AX = 4750h?  }
    JNE @Fehler     { Wenn Nein -> Fehler }

    MOV @Result,1   { "TRUE" zurckliefern }
    JMP @Ende       { und ans Ende springen }

   @Fehler:
    MOV @Result,0   { "FALSE" zurckliefern }

   @Ende:
  END;
END;



BEGIN { Inititalisierung der Variablen }
  Handle := 0;
  WITH TaskData DO BEGIN
    PrefixSegment := 0;
    InitPtr := NIL;
    RXPtr := NIL;
    StrategiePtr := NIL;
    ExitPtr := NIL;
  END;
END.

