
/******************************************************************************
* G1NNA BBS post-message creation filter.                                     *
*                                                                             *
* This program is called by the G1NNA BBS program after a message has been    *
* created. The program will search through the text of the message for any    *
* word contained in the dictionary of illegal words.                          *
* If such a word is found, this program returns 1 indicating that the         *
* message should be held. Otherwise, it returns 0 indicating that the         *
* message is OK.                                                              *
******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/*****************************************************************************/


/***********
* strmatch *
***********/

/* Search source string "src" for the string "str". Return position of "str"
	in "src" if found, or 0 otherwise. */

int strmatch(char * src, char * str)
{
	int		found;
	int		match;
	char *	start;
	char *	s1;
	char *	s2;

	s1 = src;
	s2 = str;
	found = 0;

	while (*s1 && !found)
	{
		if (*s1 == *s2)
		{
			match = 1;
			start = s1;
			while (*s2 && match)
			{
				if (*s1 == *s2)
				{
					s1++;
					s2++;
				}
				else if ((*s1 == '_') && (s2 != str))
				{
					s1++;
				}
				else
				{
					match = 0;
				}
			}
			if (*s2 == '\0')
			{
				found = 1;
			}
			s1--;
			s2 = str;
		}
		s1++;
	}

	if (!found)
	{
		return 0;
	}

	return (start - src) + 1;
}


/*****************************************************************************/


/*******
* scan *
*******/

/* Search the contents of message for bad words. */

int scan(char * output, char * msg, FILE * msgfp, FILE * dicfp)
{
	int		count;
	int		start;
	char		c;
	char		found;
	char 		buffer[2049];
	char		word[50];
	long		pos;
	FILE *	fp;

	found = 0;
	count = 0;
	pos = 0;
	while (!feof(msgfp) && !found)
	{
		while ((count < 2048) && !feof(msgfp))
		{
			fscanf(msgfp, "%c", &c);
			if (!isspace(c))
			{
				buffer[count++] = toupper(c);
			}
			else
			{
				buffer[count++] = '_';
			}
		}
		buffer[count] = '\0';
		rewind(dicfp);
		while (!found && !feof(dicfp))
		{
			fscanf(dicfp, "%s", word);
			start = strmatch(buffer, strupr(word));
			if (start)
			{
				found = 1;
				pos = pos + start - 20;
				if (pos < 0)
				{
					pos = 0;
				}
				fseek(msgfp, pos, SEEK_SET);
				fread(buffer, 1, 80, msgfp);
				buffer[80] = '\0';
				fp = fopen(output, "a");
				fprintf(fp, "%s held on word %s :\n", msg, word);
				fprintf(fp, "%s\n\n", buffer);
				fclose(fp);
			}
		}
		memmove(buffer, buffer + 2000, 49);
		count = 48;
		pos += 2049;
	}

	return found;
}


/*****************************************************************************/


/*******
* main *
*******/

/*
argc = number of arguments.
argv[0] = name of this program.
argv[1] = level.
argv[2] = output file name.
argv[3] = user flags.
argv[4] = user callsign.
argv[5] = user name.
argv[6] = filename of message.
argv[7] .. argv[argc - 1] = received data.
*/

void main(int argc, char * argv[])
{
	int			  	found;
	char				fname[128];
	unsigned char 	c;
	long				msgnum;
	FILE *			msgfp;
	FILE *			dicfp;
	FILE *			fp;

	/* Don't bother checking if the user is a SysOp. */
	if (atoi(argv[3]) & 128)
	{
		exit(0);
	}

	/* Attempt to open the dictionary file. */
	dicfp = fopen("BADWORDS.BBS", "r");
	/* If can't open it, the message is OK. */
	if (dicfp == NULL)
	{
		exit(0);
	}

	/* Attempt to open the message file. */
	msgfp = fopen(argv[6], "r");
	/* If can't open it, there's something seriously wrong! */
	if (msgfp == NULL)
	{
		fclose(dicfp);
		fp = fopen(argv[2], "w");
		fprintf(fp, "Unable to open %s\n", argv[6]);
		fclose(fp);
		exit(1);
	}

	/* Check the message for naughty words! */
	found = scan(argv[2], argv[6], msgfp, dicfp);

	if (!found)
	{
		/* Not found one, but it might be because this is a carbon copy
		message. */
		rewind(msgfp);
		fscanf(msgfp, "%*13c%c", &c);
		if (c == 'C')
		{
			/* This is a carbon copy message. */
			while (c != 254)
			{
				fscanf(msgfp, "%c", &c);
			}
			while (c != '\012')
			{
				fscanf(msgfp, "%c", &c);
			}
			fscanf(msgfp, "%ld", &msgnum);
			fclose(msgfp);
			sprintf(fname, "mail\\msg%ld.cc", msgnum);
			msgfp = fopen(fname, "r");
			if (msgfp != NULL)
			{
				/* Check the carbon copy message. */
				found = scan(argv[2], argv[6], msgfp, dicfp);
			}
		}
	}

	fclose(msgfp);
	fclose(dicfp);

	exit(found);
}
