/******************************************************************************
* G1NNA BBS post-connection filter.                                           *
*                                                                             *
* This program is called by the G1NNA BBS program after a user is fully       *
* connected to the BBS, but before the menu is sent out.							   *
*                                                                             *
* This is an example that asks the user (if they are not a BBS) for their     *
* QTH locator and stores it in a file.													   *
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>
#include <ctype.h>

#define FALSE	0
#define TRUE	1


/*****************************************************************************/


/*******
* main *
*******/

/*
argc = number of arguments.
argv[0] = name of this program.
argv[1] = level.
argv[2] = output file name.
argv[3] = user flags.
argv[4] = user callsign.
argv[5] = user name.
argv[6] .. argv[argc - 1] = received data.
*/

void main(int argc, char * argv[])
{
	char		found;
	char		callsign[7];
	char		locator[7];
	FILE *	fp;

	if (atoi(argv[4]) & 8)
	{
   	exit(0);
	}

	if (atoi(argv[1]) == 0)
	{
		found = FALSE;
		fp = fopen("locators.dat", "r");
		if (fp != NULL)
		{
			while (!feof(fp) && !found)
			{
				fscanf(fp, "%6s %6s", callsign, locator);
				if (strcmp(callsign, argv[4]) == 0)
				{
					found = TRUE;
				}
			}
			fclose(fp);
		}
		if (!found)
		{
			fp = fopen(argv[2], "w");
			fprintf(fp, "Please enter your locator (e.g. JO01HT)\n");
			fclose(fp);
			exit(2);
		}
		exit(0);
	}

	if ((strlen(strupr(argv[6])) == 6) && isalpha(argv[6][0]) &&
		 isalpha(argv[6][1]) && isdigit(argv[6][2]) && isdigit(argv[6][3]) &&
		 isalpha(argv[6][4]) && isalpha(argv[6][5]))
	{
		fp = fopen("locators.dat", "a");
		fprintf(fp, "%-6s %-6s\n", argv[4], argv[6]);
		fclose(fp);
		exit(0);
	}

	fp = fopen(argv[2], "w");
	fprintf(fp, "Invalid locator.\n");
	fprintf(fp, "Please enter your locator (e.g. JO01HT)\n");
	fclose(fp);
	exit(2);
}
