/*       A simple utility written in C, to cut files into 4K chunks       */
/*                   written by GW3TMH SysOp of GB7ABC.                   */
/*   To use this utility call it with the file name, ie  SPLIT TEST.DOC   */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void main(int argc, char *argv[])

{
FILE *fp1;
FILE *fp2;
char ch = ' ';
char string1[15];
char string2[15];
int count1 = 1;
int count2 = 1;
int i;

if (argv[1])  /* See if a file name has been entered that wants splitting */
   {
   if ((fp1 = fopen(argv[1],"r")) == NULL)       /* Does the file exist ? */
      {
      printf("Cannot find %s\n",argv[1]);   /* If it doesn't exit program */
      exit(0);
      }
   }
else exit(0);

strcpy(string1,argv[1]);

for (i = 0; i <= 15; i++)
   if (string1[i] == '.') string1[i] = NULL;

/* Create a name for the cut file, with the extension as a serial number  */

sprintf(string2,"%s.%.03d",string1,count1);

fp2 = fopen(string2,"w+");                        /* Open the output file */

/*      This is a loop, that runs until main file has all been read       */

while (ch != EOF)
   {
   ch = getc(fp1);
   fputc(ch,fp2);
   count2++;
   
   /* When file is over 4000 long, close it, and open another one */

   if (count2 > 4000 && ch == '\n')
      {
      fclose(fp2);
      count1++;
      count2 = 0;
      sprintf(string2,"%s.%.03d",string1,count1);
      fp2 = fopen(string2,"w+");
      }
   }

fclose (fp1);
fclose (fp2);

}
