//	GetPass 4.0 - C_FILTER for F6FBB BBS Software

//  Written by Marco Savegnago IW3FQG

#ifdef __INCL_WARNING

#include "gpwarn.h"

#include <fstream.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <ctype.h>

WarningMessage::WarningMessage( char *call, char *workdir, char *msg )
{
	callsign = call;

	_callsign = new char [ strlen ( call ) + 1 ];

    strcpy( _callsign , callsign );

    char *p;

	if (NULL!=(p=strchr (_callsign,'-')))
	{
		*p++=NULL;
		strcat(_callsign,p);
	}

    fnsplit( workdir, curr_drive, curr_dir, NULL, NULL );

    fnmerge( fname, curr_drive, curr_dir, _callsign, ".MSG" );

    theMessage=msg;
}

WarningMessage::~WarningMessage()
{
	delete _callsign;
}

int WarningMessage::readWarningMessage()
{
	ifstream warnMsg(fname);

    if ( ! warnMsg.good() )
                        return 1;

    char temp[ 80 ];

    do
	{
		warnMsg.getline( temp, sizeof ( temp ) );
		cerr << temp << endl;
	}
	while (! warnMsg.eof() );

	warnMsg.close();

	remove (fname);

	return 0;
}

int WarningMessage::makeWarningMessage( int level )
{
	ofstream warnMsg ( fname, ios::app );

	if( ! warnMsg.good() )
	{
#ifdef __DEBUG__
		cerr << "DEBUG: I/O Error opening warning file" << endl;
#endif
		return(2);
	}

	char *p=theMessage;

	while (*p)
	{
		if (*p == '$')
		{
        	p++;
            switch(toupper(*p))
            {
            	case 'D':
                	struct date d;
                    getdate( &d );
                    warnMsg << (int) d.da_day << '/' << (int) d.da_mon << '/' << d.da_year;
                    break;

                case 'T':
                	struct time t;
                    gettime( &t );
                    warnMsg << (int) t.ti_hour << ':'<< (int) t.ti_min << ':' << (int) t.ti_sec;
                    break;

                case 'N':
                	warnMsg << callsign;
                    break;

                case 'A':
            		warnMsg << level;
                	break;

                default:
                	warnMsg << *p;
                    break;
            }
        }
        else
        	warnMsg << *p;

        p++;
    }

    if( ! warnMsg.good() )
	{
#ifdef __DEBUG__
		cerr << "DEBUG: I/O Error writing warning file" << endl;
#endif
		return( 2 );
	}

    warnMsg.close(); // dummy

	return 0;
}

#endif // __INCL_WARNING
