/*******************************************************************

	GetPass 4.0 - C_FILTER for F6FBB BBS Software

	Written by Marco Savegnago IW3FQG

	Port access control class implementation

*******************************************************************/

#ifdef	__INCL_ACCESS_CTL

#include "gpaccess.h"
#include "tdef.h"
#include "gppass.h"

#include <ctype.h>
#include <fstream.h>

int PortAccessControl::parseLine(char* portList)
{
	numOfPorts=0;

    char *p=portList;

	if(!*p)
		return 0;

    while(*p)
    {
		numOfPorts++;

    	while(*p && !isspace(*p++))
		;

		while(*p && isspace(*p)) p++;
	}

	char **tArgs = new char *[numOfPorts];

	p=portList;

	theArgs=tArgs;

	while(*p)
	{
		*tArgs++=p;

		while(*p && !isspace(*p++))
		;

		if(*p)
			*(p-1) = EOS;

		while(*p && isspace(*p))
								p++;
	}

	return	numOfPorts;
}

int PortAccessControl::isValid(int inport)
{
	// return:
	//  		0 Port is not OK
	// 	   		1 I/O error
	// 	   		2 Port is OK
	//     		3 Port don't need the password
	//     		4 Port is ok but not support MD2
	//     		5 Port is ok but not support Matrix

	enum AccessType { __NONO__, __NOPWD__ , __NOMD2__, __NOMTX__ };

	AccessType	accessType;

	Boolean found = False;

	int ret=2, retCode = 0;

	ifstream access_file( accessFname );

	if ( ! access_file.good() )
	{
#ifdef __DEBUG__
		cout << "DEBUG: I/O error opening file " << accessFname << endl;
#endif
		return( 1 );
	}

	char temp[ LENLINE ];

	char label[ 20 ];

    Boolean done = False;

	while ( access_file.getline( temp, sizeof ( temp ) ), ! access_file.eof() )
	{
		char *s = temp;
		char *d = label;

		if(isComment(s))
				continue;

		skipSpace(s);

		if(isComment(s))
				continue;

		while ( !isspace( *s ) )
					*d++ = *s++;

		*d = EOS;

		if( stringMatch( callsign, label ) )
		{
			found = True;

			skipSpace(s);

			TString accessList(s);

            char *_s = s;

			if( NULL != (s=accessList.isStringInc("__NOPWD__" )))
				accessType = __NOPWD__;
			else
				if( NULL != (s=accessList.isStringInc("__NOMD2__" )))
					accessType = __NOMD2__;
			else
				if( NULL != (s=accessList.isStringInc("__NOMTX__" )))
					accessType = __NOMTX__;
			else
            {
				accessType = __NONO__;
                ret = 0;
             	s = _s;
            }

			if(parseLine(s))
			{
				for(int j=0; j < numOfPorts; j++)
				{
					if( isdigit(*theArgs[j]) || *theArgs[j] == '*' )
					{
						if(inport == atoi(theArgs[j]))
						{
							switch(accessType)
							{
								/* Port is OK */
								case __NONO__:
                                    done    = True;
									retCode = 2;
									break;

								/* Port do not need the password */
								case __NOPWD__:
									retCode = 3;
									break;

								/* Port is ok but not support MD2 */
								case __NOMD2__:
									retCode = 4;
									break;

								/* Port is ok but not support Matrix */
								case __NOMTX__:
									retCode = 5;
									break;

                                default:
                                	break;
							}
							break;
						}
					}
				}
			}
            if(done)
				break;
		}
	}

	access_file.close(); // dummy

	if(found)
		ret = retCode;

	return( ret );
}

#endif //__INCL_ACCESS_CTL
