
/*
 * J'ai rajoute le "conio.h" pour mon wherex() et wherey()
 * Un parametre de + a GetLine pour limiter la longueur de la chaine
 * le retour de fgetc est un int, a corriger sinon ca marche pas sous Linux
 */

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "mill.h"

//------ Prototype ------
int GetLine (char *String, FILE * File, int len);

//---------------------------------------------------------------------------
//------ Fonction principale ------------------------------------------------
//---------------------------------------------------------------------------
int main (int Argc, char *Argv[])
{
	char Qualifier[255];
	char NameOfFul[255], NameOfIdx[255];

	long Pos = 0;
	int index;
	unsigned short Pds;
	int Progress = 0;
	unsigned short CheckSum;
	unsigned short Offset;
	int PosX, PosY;

	struct
	{
		unsigned short CheckSum;
		unsigned char Offset;
	}
	Record;

	FILE *Ful;
	FILE *Idx;

	printf ("F5MZN's DxNet DataBase indexation utility v2.0\n");

	//------ Lecture des arguments ------
	if (Argc < 2)
	{
		printf ("\n*** Error : can't continue.\nYou must specify the database name\n");
		return (1);
	}


	index = 0;
	strcpy (NameOfFul, Argv[1]);
	while (NameOfFul[index])
	{
		if (NameOfFul[index] == '.')
			NameOfFul[index] = '\0';

		index++;
	}

	strlwr (NameOfFul);
	strcpy (NameOfIdx, NameOfFul);
	strcat (NameOfFul, ".ful");
	strcat (NameOfIdx, ".idx");


	Ful = fopen (NameOfFul, "rt");
	if (!Ful)
	{
		printf ("*** Error : Enable to open %s\n", strupr (NameOfFul));
		return (2);
	}

	Idx = fopen (NameOfIdx, "wb");
	if (!Idx)
	{
		printf ("*** Error : Enable to open %s\n", strupr (NameOfIdx));
		fclose (Ful);
		return (3);
	}

	printf ("\nCreating database index file %s ... ", strupr (NameOfIdx));
	PosX = wherex ();
	PosY = wherey ();

	while (1)
	{
		if (Progress++ == 50)
		{
			Progress = 0;
			MILL_turn (PosX, PosY);
		}

		//------ Lecture du pointeur ------
		Offset = (int) (ftell (Ful) - Pos);
		Pos = ftell (Ful);

		//------ Lecture d'une ligne dans la table ------
		if (!GetLine (Qualifier, Ful, sizeof (Qualifier)))
			break;

		strupr (Qualifier);

		//------ Calcul du CheckSum ------
		index = 0;
		CheckSum = 0;
		Pds = 256;
		strlwr (Qualifier);
		while (Qualifier[index])
		{
			CheckSum += (int) Qualifier[index++] * (int) Pds;

			Pds = (Pds == 1 ? 256 : 1);
		}
		//------ Ecriture de la structure dans le fichier ------
		//Crer des enregistrements vide avec un offset maximum
		//si l'offset dpasse 255 (char)
		while (Offset > 255)
		{
			Record.CheckSum = 0;
			Record.Offset = 255;
			Offset -= 255;
			fwrite (&Record, sizeof (Record), 1, Idx);
		}

		Record.CheckSum = CheckSum;
		Record.Offset = (unsigned char) Offset;
		fwrite (&Record, sizeof (Record), 1, Idx);

		//------ Passe au qualifier suivant ------
		while (strcmp (Qualifier, "&&"))
		{
			if (!GetLine (Qualifier, Ful, sizeof (Qualifier)))
				break;

		}						/* end while */
	}							/* end while */

	gotoxy (PosX, PosY);
	printf ("Done.\n");

	fclose (Idx);
	fclose (Ful);

	return (0);
}

//---------------------------------------------------------------------------
//------ GetLine ------------------------------------------------------------
//---------------------------------------------------------------------------
int GetLine (char *String, FILE * File, int len)
{
	char *Ptr = String;
	int Chr;
	int nb = 0;

	while (1)
	{
		Chr = fgetc (File);
		/* Ignore return for dos/linux compatibility */
		if (Chr == '\r')
			continue;
		if (Chr == EOF || Chr == '\n')
			break;
		/* Limite la taille de la chaine */
		if (++nb < (len - 1))
			*Ptr++ = Chr;
	}

	*Ptr = '\0';

	return ((Chr == EOF ? 0 : 1));
}
