
/*
 *	cmd_sys.c
 *
 *	Clusse system related commands
 */

#include "csock.h"
#include "cmd_sys.h"
#include "cstring.h"
#include "version.h"
#include "hmalloc.h"
#include "ctime.h"

/*
 *
 */
 
char cst2chr(enum cstype_t cst)
{
	switch (cst) {
	case cst_unknown:
		return '?';
	case cst_incoming:
		return 'I';
	case cst_outgoing:
		return 'O';
	}
	return '?';
}

char css2chr(enum csstate_t css)
{
	switch (css) {
	case css_unknown:
		return '?';
	case css_connecting:
		return 'i';
	case css_connected:
		return 'C';
	case css_disconnecting:
		return 'd';
	case css_disconnected:
		return 'D';
	}
	return '?';
}

/*
 *	socket listing/manipulation
 */

int cmd_sockets(struct csock_t *s, int argc, char **argv)
{
	struct csock_t *p;
	
	csputs(s, "Sockets:                                 Data      Queue     Buflen\n");
	csputs(s, "fd  T S Callsign  Node            Port  in   out  in   out  in   out\n");
	
	for (p = sockets; (p); p = p->next) {
		csprintf(s, "%-3d %c %c %-9.9s %-15.15s %-5.5s %s",
			p->fd, cst2chr(p->type), css2chr(p->state), 
			(p->call) ? p->call : "?",
			(p->node) ? p->node : "-",
			(p->port) ? p->port : "?",
			bytes2str(p->in_count));
		csprintf(s, " %s", bytes2str(p->out_count));
		csprintf(s, " %s", bytes2str(p->ibuf.pos));
		csprintf(s, " %s", bytes2str(p->obuf.pos));
		csprintf(s, " %s", bytes2str(p->ibuf.len));
		csprintf(s, " %s\n", bytes2str(p->obuf.len));
	}
	
	return 0;
}

/*
 *	memory status
 */

int cmd_memory(struct csock_t *s, int argc, char **argv)
{
	csprintf(s, "Memory information:\n"
		"Allocations:   %5ld, %ld KB\n"
		"Frees:         %5ld, %ld nulls\n"
		"Reallocations: %5ld\n"
		"strdups:       %5ld\n",
		hmallocs, hmallocs_b / 1024,
		hfrees, hfree_nulls, hreallocs, hstrdups);
	return 0;
}

/*
 *	Version information
 */
 
int cmd_version(struct csock_t *s, int argc, char **argv)
{
	csprintf(s, "%s\n\n", SOFT_STRING);
	csprintf(s, "Compiled: on %s by %s@%s\n",
		COMPILE_DATETIME, COMPILE_BY, COMPILE_HOST);
	csprintf(s, "Compiler: %s running on %s (%s)\n",
		COMPILER, COMPILE_KERNEL, COMPILE_PLATFORM);
	return 0;
}

/*
 *	Uptime
 */
 
int cmd_uptime(struct csock_t *s, int argc, char **argv)
{
	csprintf(s, "Up: %s\n", secs2str_l(uptime()));
	return 0;
}

