
#include <string.h>

#include "config.h"
#include "ctypes.h"
#include "cfgfile.h"
#include "cfg_iface.h"
#include "cfg_links.h"
#include "log.h"
#include "csock.h"
#include "cstring.h"

/*
 *	Configuration file commands
 */

#define _CFUNC_ (int (*)(void *dest, int argc, char **argv))

static struct cfgcmd cfg_cmds[] = {
	{ "hostname",		_CFUNC_ do_string,		&hostname		},
	{ "callsign",		_CFUNC_ do_callsign,		&clucall		},
	{ "qth",		_CFUNC_ do_string,		&qth			},
	{ "qth_loc",		_CFUNC_ do_string,		&qth_loc		},
	{ "sysopcall",		_CFUNC_ do_callsign,		&sysop_call		},
	{ "sysopname",		_CFUNC_ do_string,		&sysop_name		},
	{ "loglevel",		_CFUNC_ do_int,			&log_level		},
	{ "logdest",		_CFUNC_ do_int,			&log_dest		},
	{ "tcplisten",		_CFUNC_ do_tcplisten,		&listenq		},
	{ "ax25listen",		_CFUNC_ do_ax25listen,		&listenq		},
	{ "netromlisten",	_CFUNC_ do_netromlisten,	&listenq		},
	{ NULL,			NULL,				NULL			}
};

static struct cfgcmd links_cmds[] = {
	{ "link",		_CFUNC_ do_link,		&thislink		},
	{ "destcall",		_CFUNC_ do_destcall,		&thislink		},
	{ "mycall",		_CFUNC_ do_mycall,		&thislink		},
	{ "protocol",		_CFUNC_ do_protocol,		&thislink		},
	{ "script",		_CFUNC_ do_script,		&thislink		},
	{ NULL,			NULL,				NULL			}
};

call_t *clucall;
char *hostname;

call_t *sysop_call;
char *sysop_name;
char *qth;
char *qth_loc;

/*
 *	Read configuration files
 */

void read_config(void)
{
	read_cfgfile(CONFIG_F, cfg_cmds);
	read_cfgfile(INTCONFIG_F, cfg_cmds);
	
	if (!( (hostname) && (clucall) && (sysop_call) && (sysop_name)
	   && (qth) )) {
	   	log(L_CRIT, "Missing entries in configuration file!");
	   	exit(1);
	}
	hstrupr((char *)clucall);
	
	read_cfgfile(LINKS_F, links_cmds);
}
