{$F-} {$R-} {$Q-} {$V-} {$B-} {$X+}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Screen;

  { Implements the console screen handling. An amount of video hardware
    specific code, primitive windowing features etc. Half of the
    video I/O is direct, the other half through BIOS. Uuuglyyyy. }

Interface
Uses Dos, CStrings, ConfFile;

Type
  CursorType  = (On, Off, Big, Small, None);
  CursorPos   = Record
                x, y           : Byte;
                End;

  SavedScreen = Record
                SSave          : Pointer;
                Page,
                Mode           : Byte;
                BufStart,
                BufSize        : Word;
                VideoSegment   : Word;
                CursorPosition : Word;
                CursorSize     : Word;
                End;

Var
  UseDirectVideo        : Boolean;       { Kytetnk direct video i/o }

 { ** Asetukset kynnistettess }
  Page,                                  { Display page }
  OrigAttr,                              { Color attribute }
  OrigCursStart,OrigCursStop,            { Cursor size }
  OrigMode              : Byte;          { Video mode }
 { ** }

  Windowed              : Boolean;       { Onko ikkunat avattu }

  InsertMode            : Boolean;       { Insert tila }
  CursorSize            : CursorType;    { Kursorin koko }
  CursorStat            : Boolean;       { Onko se pll }

  RxPos                 : CursorPos;     { Rxikkuna pos }
  MonPos                : CursorPos;     { Monikkuna pos }

  EditLn                : String[80];    { Txrivi }
  EdWinLine,
  EditXPos              : Byte;          { Txrivi pos }

  History               : Array[1..10]
                          of String[80]; { Viimeiset komennot }
  HistoryPointer        : Byte;          { Miss mennn }
  HistoryCurrent        : Byte;

  ConsoleMode           : Byte;          { Konsolin tila:
                                            0 - vapaa
                                            1 - Connected to Clusse
                                            2 - Connected to node
                                         }

  Dt                    : DateTime;      { Date & time }
  Now                   : LongInt;       { Packed datetime }
  DayOfWeek             : Word;

  StartUpTime           : LongInt;
  Uptime                : LongInt;
  HWTimer               : DWord Absolute $0040:$006c;
  StartUpTimer          : DWord;

  Pal                   : PPalette;
  VideoSeg     : Word;

Const
  VGA         : Boolean = False;          { VGA nyttkortti }

 { net }
Procedure Toc;                            { Ynht }
Procedure BeepG;                          { CTRL-G ni }

 { Kursori }
Procedure SetCursorSize(Size:CursorType); { Asettaa kursorin koon }

 { Ikkunoiden st }
Procedure EdWinUp;
Procedure EdWinDown;

 { Kello }
Procedure ClockUpDate;                    { Pivitt kellonajan ruudunnurkkaan }
Procedure Wait(secs:Byte;Const forWhat:String); { Odottaa }
Function  HWUptime:LongInt;               { Pystyssoloaika sekunneissa }

 { Output }
Procedure Display(St:String);            { Rx-ikkunaan teksti }
Procedure Stat;                          { Pivitt statusikkunan }
Procedure Monitor(Const Str:String);           { Monitori-ikkunaan }
Procedure Action(r:Byte;Const Rivi:String);    { Action-ikkunaan info }
Procedure ProgressMeter(r:Real);         { Mittarimato, 0 <= r <= 1 }
Procedure SpeechState(ptt:Boolean; w, r, s: Word);

 {$IFDEF StopWatch}

Procedure StartWatch;
Procedure MarkWatch;
Procedure StopWatch;

 {$ENDIF}

Procedure SaveScreen(var Saved:SavedScreen);
Procedure RestoreScreen(var Saved:SavedScreen);

 { Init/Close }
Procedure InitScreen;                    { Screen init }
Procedure InitWindows;                   { Windows init }
Procedure OriginalScreen;
Procedure CloseScreen;                   { Screen outit }

 { ***************************************************************** }

Implementation
Uses Crt, MultiTsk, xmsLib, Bpq, Config, Convers, Protocol;

Type
 ScreenLine  = Array[1..160] of Char;
 ScreenBufT  = Array[1..50] of ScreenLine;

Const
 ActionGroup : Array[65..73] of String[9] =
                ('System:', 'Linker:', 'Cluster:', 'Pinger:',
                 'Console:', 'Expiry:', 'Mailer:', 'Unproto:',
                 'Database:');

Var

  ScreenBuf    : ^ScreenBufT;

  CrQueued     : Boolean;

 {$IFDEF StopWatch}
  MarkCount,
  MarkStart    : LongInt;
 {$ENDIF}

  RxWinLines,
  RxWinLast,
  MonWinLines,
  MonWinLine,
  MonWinFirst,
  MonWinLast,
  ActLen       : Byte;

 { ***************************************************************** }

Procedure Toc;
Begin
 Sound(100);
 Delay(30);
 NoSound;
End;

Procedure BeepG;
Begin
 Sound(1318);
 Delay(40);
 Sound(1046);
 Delay(40);
 NoSound;
End;

 { ********************************************************************** }

Procedure SetVGAMode(VGAMode:Byte);

    procedure Lines350;
    { Set 350 scanlines on VGA display }
    InLine(
      $B8/$03/$00/  {  mov   AX,$0003  }
      $CD/$10/      {  int   $10       }
      $B8/$01/$12/  {  mov   AX,$1201  }
      $B3/$30/      {  mov   BL,$30    }
      $CD/$10);     {  int   $10       }

    procedure Lines400;
    { Set 400 scanlines on VGA display }
    InLine(
      $B8/$03/$00/  {  mov   AX,$0003  }
      $CD/$10/      {  int   $10       }
      $B8/$02/$12/  {  mov   AX,$1202  }
      $B3/$30/      {  mov   BL,$30    }
      $CD/$10);     {  int   $10       }

    procedure Font8x8;
    { Set 8x8 CGA-font on VGA display. }
    InLine(
      $B8/$03/$00/  {  mov   AX,$0003  }
      $CD/$10/      {  int   $10       }
      $B8/$12/$11/  {  mov   AX,$1112  }
      $B3/$00/      {  mov   BL,0      }
      $CD/$10);     {  int   $10       }

    procedure Font8x14;
    { Set 8x14 EGA-font on VGA display }
    InLine(
      $B8/$03/$00/  {  mov   AX,$0003  }
      $CD/$10/      {  int   $10       }
      $B8/$11/$11/  {  mov   AX,$1111  }
      $B3/$00/      {  mov   BL,0      }
      $CD/$10);     {  int   $10       }

Begin

 Case VGAMode of
  2 : Begin
      Lines400;
      Font8x14;
      MonWinLast := 28;
      End;
  3 : Begin
      Lines350;
      Font8x8;
      MonWinLast := 43;
      End;
 End;

End;

 { ********************************************************************** }

Procedure WVideoMode;
Var
  regs : Registers;
Begin

  If (Conf^.Crt.CrtType > 1) and not VGA
    then Conf^.Crt.CrtType := 1;

  Case Conf^.Crt.CrtType of
   1   : Begin
         TextMode(259);
         If VGA
           then MonWinLast := 50
           else MonWinLast := 43;
         End;
   2,3 : SetVGAMode(Conf^.Crt.CrtType);
  else Begin
       TextMode(3);
       MonWinLast := 25;
       End;
  End;

  Regs.ah := $0f;
  Intr($10,Regs);   {  Huom. antaa vrn rivimrn ah:ssa }

  If Regs.al = 7
    then Regs.es := $B000
    else Regs.es := $B800;

  If DesqViewActive
    then Begin
         Regs.di := 0;
         Regs.ax := $FE00;
         Intr($10, Regs);
         End;

  VideoSeg := Regs.es;
  ScreenBuf := Ptr(VideoSeg, 0);

  If (EdWinLine = 0) or (EdWinLine > MonWinLast)
    then Case Conf^.Crt.CrtType of
           0 : EdWinLine := 20;
           1 : EdWinLine := 25;
           2 : EdWinLine := 24;
           3 : EdWinLine := 25;
         End;

  MonWinFirst := EdWinLine + 1;
  MonWinLine := 1;
  MonWinLines := MonWinLast - EdWinLine;
  RxWinLines := EdWinLine - 4;
  RxWinLast := EdWinLine - 1;

End;

 { ********************************************************************** }

Procedure SetCursorSize(Size:CursorType);      { Asettaa kursorin koon }
Var Regs : Registers;
Begin

 If (CursorStat = False) and (Size <> Off) and (Size <> On)
    then Begin
         CursorSize := Size;
         Size := Off
         End

 else If Size = On then Begin
                        CursorStat := True;
                        Size := CursorSize;
                        End

 else If Size = Off then Begin
                         CursorStat := False;
                         Size := None;
                         End
 else CursorSize := Size;

 Regs.ah := $1;
 Case Size of
  None  : Begin { Kursori piiloon }
          Regs.ch := $ff;
          Regs.cl := $ff;
          End;
  Small : Begin { Pieni kursori }
          Regs.ch := $6;
          Regs.cl := $7;
          End;
  Big   : Begin { Iso kursori }
          Regs.ch := $0;
          Regs.cl := $e;
          End;
 End; { Case }

 Intr($10,Regs);

End;

 { ********************************************************************** }

Procedure DWrite(s:String; x, y, color:Byte);
Var
  idx, cdx : Byte;
Begin

  idx := x * 2;
  cdx := 1;

  While cdx <= Length(s)
   do Begin

      ScreenBuf^[y][idx+2] := Chr(Color);
      ScreenBuf^[y][idx+1] := s[cdx];

      Inc(idx,2);
      Inc(cdx);

      End;

End;

 { ********************************************************************** }

Procedure DScrollUp(FromLine, ToLine, Bg:Byte);
Var
  b : Byte;
Begin

 b := FromLine;
 Repeat
   Move(ScreenBuf^[b + 1][1], ScreenBuf^[b][1], 160);
   Inc(b);
 until b = ToLine;

 b := 1;
 Repeat
   ScreenBuf^[ToLine][b] := Chr(Bg);
   Inc(b);
   ScreenBuf^[ToLine][b] := #0;
   Inc(b);
 until b = 160;

End;

 { ********************************************************************** }

Procedure EdWin;
Begin

  { Takaisin tx-ikkunaan }
  Window(1,EdWinLine,80,EdWinLine);
  GotoXY(EditXPos,1);

End;

 { ********************************************************************** }
{ Ikkunoiden st }

Procedure EdWinUp;
Begin

  If RxWinLines > 1
    then Begin
         Window(1,1,80,MonWinLast);

         Dec(RxWinLast);
         If RxPos.Y = RxWinLines
           then Begin
                Dec(RxPos.Y);
                GotoXY(1,4);
                End
           else GotoXY(1,RxWinLast);
         DelLine;
         Dec(RxWinLines);

         Dec(EdWinLine);

         If MonPos.Y = MonWinLines
           then Inc(MonPos.Y);
         Dec(MonWinFirst);
         Inc(MonWinLines);

         GotoXY(1,MonWinFirst);
         TextAttr := Pal^[cmMonText];
         InsLine;

         EdWin;
         End;

End;

Procedure EdWinDown;
Begin

  If MonWinLines > 0
    then Begin
         Window(1,1,80,MonWinLast);

         GotoXY(1,MonWinFirst);
         DelLine;

         TextAttr := Pal^[cmRxRec];
         If RxPos.Y = RxWinLines
           then Begin
                Inc(RxPos.Y);
                GotoXY(1,4);
                End
           else GotoXy(1,EdWinLine);
         InsLine;

         Inc(RxWinLines);
         Inc(RxWinLast);

         If MonPos.Y = MonWinLines
           then Dec(MonPos.Y);
         Inc(MonWinFirst);
         Dec(MonWinLines);

         Inc(EdWinLine);

         EdWin;
         End;

End;

 { ********************************************************************** }
 { Clock updating }

Procedure ClockUpDate;
Var
   s            : String;
Begin

      Inc(Uptime);
      GetDate(Dt.Year,Dt.Month,Dt.Day,DayOfWeek);
      PackTime(Dt,Now);

{
      Window(1,1,80,3);

      GotoXY(50,1);
      TextAttr := Pal^[cmStatClock];
      Write(Kello);
}
      DWrite(PadRight(30,DateTimeStr),49,1,Pal^[cmStatClock]);

      { Kyttjt, linkit }
{
      TextAttr := Pal^[cmStat1];
      GotoXY(21,1);
      Write('Users: ' + PadRight(3,Int2Str(NUserCount)) + '/' + PadLeft(2,Int2Str(LUserCount)) + ' Nodes: '
          + PadRight(3,Int2Str(NodeCount)) + '/' + PadLeft(2,Int2Str(PCLinks)));
}
      DWrite('Users:' + PadRight(5,Int2Str(NUserCount)) + '/' + PadLeft(3,Int2Str(LUserCount)) + 'Nodes:'
          + PadRight(4,Int2Str(NodeCount)) + '/' + PadLeft(2,Int2Str(PCLinks)) ,20,1,Pal^[cmStat1]);

      { BPQ buff, muisti }
      If MemAvail < HeapMinFree then HeapMinFree := MemAvail;
      If MaxAvail < HeapMinFreeMax then HeapMinFreeMax := MaxAvail;
{      TextAttr := Pal^[cmStat3];}

      Case Conf^.Ifc.IfType of
        G8BPQ : Begin
{               GotoXY(41,3);
                Write('BPQ ' + PadRight(3,Int2Str(w)));}
                DWrite('BPQ ' + PadRight(3,Int2Str(IfBuffers)),41,3,Pal^[cmStat3]);
                End;
      End;

{      GotoXY(48,3);
      Write(' Heap fr ' + PadRight(6,Int2Str(MemAvail))
               + ' us ' + PadRight(6,Int2Str(HeapUsed)));}
      DWrite('Heap fr ' + PadRight(6,Int2Str(MemAvail))
               + ' us ' + PadRight(6,Int2Str(HeapUsed)),49,3,Pal^[cmStat3]);

      { XMS }
      If XMSPresent
        then Begin
{             GotoXY(49,2);
             TextAttr := Pal^[cmStat2];
             Write('XMS  fr'  + PadRight(6,Int2Str(xmsTotalFreeMemory))
                   + 'K us' + PadRight(6,Int2Str(xmsUsed))
                   + 'K');}
             DWrite('XMS  fr'  + PadRight(6,Int2Str(xmsTotalFreeMemory))
                   + 'K us' + PadRight(6,Int2Str(xmsUsed))
                   + 'K',49,2,Pal^[cmStat2]);
             End;

{      EdWin;}

End;

 { ***************************************************************** }

Procedure Wait(secs:Byte;Const forWhat:String); { Odottaa }
Var
  b : Byte;
Begin

 For b := secs downto 1
   do Begin
      ClockUpDate;
      Window(1,2,80,2);
      TextAttr := Pal^[cmStat2];
      Write(Forwhat + ' in ' + Int2Str(b) + ' seconds.  ');
      Window(1,EdWinLine,80,EdWinLine);
      GotoXY(EditXPos,1);
      Delay(1000);
      End;

 Window(1,2,80,2);
 TextAttr := Pal^[cmStat2];
 Write(Spaces(Length(forWhat)+16));

 EdWin;

End;

 { ***************************************************************** }

Function HWUptime:LongInt;                 { Pystyssoloaika sekunneissa }
Var
 i, ii : LongInt;
 r     : Real;
Begin

 i :=  HWTimer[1] * 1677216
     + HWTimer[2] * 65536
     + HWTimer[3] * 256
     + HWTimer[4];

 ii := StartUpTimer[1] * 1677216
     + StartUpTimer[2] * 65536
     + StartUpTimer[3] * 256
     + StartUpTimer[4];

 r := (i - ii) / 18.2;
 HWUptime := Round(r)

End;

 { ***************************************************************** }

Procedure Display(St:String);
Var
  b, Beepcount : Byte;
Begin

 BeepCount := 0;

 If CrQueued
   then Begin
        st := Cr + st;
        CrQueued := False;
        End;

 If (St[Length(St)] = Cr)
   then Begin
        Delete(St,Length(St),1);
        CrQueued := True;
        End;

 While Pos(Chr(7),St) > 0
  do Begin
     Inc(BeepCount);
     Delete(St,Pos(Chr(7),St),1)
     End;

 Window(1,4,80,RxWinLast);
 GotoXY(RxPos.X,RxPos.Y);
 Write(AddLf(St));


 RxPos.X := WhereX; RxPos.Y := WhereY;

 EdWin;

 For b := 1 to BeepCount
  do BeepG;

End;

{ ***************************************************************** }

Procedure Stat;
Begin { Stat }

  Window(1,3,80,3);

  TextAttr := Pal^[cmStat3];

  GotoXY(74,1);
  If MO_Band in Conf^.Ifc.MonitorMode
    then Write('B')
    else Write(' ');
  If MO_Actions in Conf^.Ifc.MonitorMode
    then Write('A ')
    else Write('  ');

  If Insertmode Then Write('Ins')
                Else Write('Ovr');

  EdWin;

End; { Stat }

 { ***************************************************************** }

Procedure Monitor(Const Str:String);
Begin

  If MonWinLines = 0 then Exit;

  Window(1,MonWinFirst,80,MonWinLast);
  GotoXy(MonPos.X,MonPos.Y);

  Write(CrLf + AddLf(Str));

  MonPos.Y := WhereY;
  MonPos.X := WhereX;

  If MonPos.Y = MonWinLines + 1
    then MonPos.Y := MonWinLines;
  If MonPos.X = 80 then Begin
                    MonPos.X := 1;
                    Inc(MonPos.Y);
                    If MonPos.Y = MonWinLines + 1 Then MonPos.Y := MonWinLines;
                    End;

  EdWin;

End;

 { ***************************************************************** }

Procedure Act_Monitor(p:Byte;Const Str:String);
Var Info : String[9];
Begin

 If p < 65
   then Info := LUser[p]^.f^.Call + ':'
   else Info := ActionGroup[p];

 TextAttr := Pal^[cmMonSystem];
 Screen.Monitor(Format(False,TimeStrL(now) + ' ' + Info,Str));

End;

 { ***************************************************************** }

Procedure Action(r:Byte;Const Rivi:String);
Var
 Info       : String[9];
 s          : String;
Begin { Action }

  If r < 65 Then Info := LUser[r]^.f^.Call
            else Info := ActionGroup[r];

  s := StripBeeps(Rivi);

  If MO_Actions in Conf^.Ifc.MonitorMode then Act_Monitor(r,s);

  Info := PadLeft(9,Info);

  Window(1,3,80,3);
  TextAttr := Pal^[cmStatAction];
  Write(Info + ' ' + PadLeft(ActLen,s));
  EdWin;

End; { Action }

 { ***************************************************************** }

Procedure ProgressMeter(r:Real);         { Mittarimato }
Var
  s    : String[12];
  t, b : Byte;

Begin

 If r > 0
  then Begin
       t := Round(r * 10);
       s := '[';
       b := 0;
       For b := 1 to t
         do s := s + '';
       While b < 10 do Begin
                       Inc(b);
                       s := s + ' ';
                       End;
       s := s + ']';
       End
  else s := '            ';

 Window(1,2,13,2);
 TextAttr := Pal^[cmStat2];
 Write(s);
 EdWin;

End;

 { ***************************************************************** }

Procedure SpeechState(ptt:Boolean; w, r, s: Word);
Begin

 If ptt
   then DWrite('TX',20,2,Pal^[cmStat2])
   else DWrite('RX',20,2,Pal^[cmStat2]);

 DWrite(PadRight(4, Int2Str(r)), 23, 2, Pal^[cmStat2]);
 DWrite(PadRight(4, Int2Str(w)), 28, 2, Pal^[cmStat2]);
 DWrite(PadRight(3, Int2Str(s)), 33, 2, Pal^[cmStat2]);

End;

 { ***************************************************************** }
 {$IFDEF StopWatch}

Procedure StartWatch;
Begin

 MarkCount := 0;
 MarkStart := HWTimer;

End;

Procedure MarkWatch;
Begin

 Inc(MarkCount);

End;

Procedure StopWatch;
Var
 MarkStop, MarkTime : LongInt;
Begin

 MarkStop := HWTimer;
 MarkTime := MarkStop - MarkStart;

 Window(1,2,80,2);
 TextAttr := Color.Stat2;
 GotoXY(1,1);
 Write('StopWatch: ' + Int2Str(MarkCount div MarkTime) + ' marks per tick, ' + Int2Str(MarkCount) + ' marks.');

 EdWin;

End;

 {$ENDIF}

 { ***************************************************************** }
 { Nytt muistiin... }
 { ***************************************************************** }

Procedure SaveScreen(var Saved:SavedScreen);
Var
  Bp         : ^Byte;
  Wp         : ^Word;
  Regs       : Registers;
Begin

  Wp := Ptr(Seg0040,$4c); { Buffer Size }
  Saved.BufSize := Wp^;

  Regs.ah := $0f;
  Intr($10,Regs);   {  Huom. antaa vrn rivimrn }
  Saved.Page := Regs.bh;

  If (Saved.BufSize > 16384) or (MaxAvail < Saved.BufSize)
    then Saved.SSave := nil
    else Begin
         Saved.VideoSegment := VideoSeg;

         Wp := Ptr(Seg0040,$4e); { Start address of buffer }
         Saved.BufStart := Wp^;

         Wp := Ptr(Saved.VideoSegment,Saved.BufStart);
         GetMem(Saved.SSave,Saved.BufSize);
         Move(Wp^,Saved.SSave^,Saved.BufSize);
         Regs.ah := 3;
         Regs.bh := Saved.Page;
         Intr($10,Regs);
         Saved.CursorSize := Regs.cx;
         Saved.CursorPosition := Regs.dx;
         End;

End;

Procedure RestoreScreen(Var Saved:SavedScreen);
Var
  P    : Pointer;
  Regs : Registers;
Begin

 Regs.ah := 5;
 Regs.al := Saved.Page;
 Intr($10,Regs);
 WVideoMode;

 If Saved.SSave <> nil
   then Begin
        Regs.ah := 1;
        Regs.cx := Saved.CursorSize;
        Intr($10,Regs);
        Regs.ah := 2;
        Regs.bh := Saved.Page;
        Regs.dx := Saved.CursorPosition;
        Intr($10,Regs);
        P := Ptr(Saved.VideoSegment,Saved.BufStart);
        Move(Saved.SSave^,P^,Saved.BufSize);
        FreeMem(Saved.SSave,Saved.BufSize);
        End;

End;

 { ***************************************************************** }

Procedure BackupScreenParameters;
Var
  Regs : Registers;
Begin
 { Otetaan alkuperiset CRT asetukset talteen }
  { Mode, Page }
  Regs.ah := $0f;
  Intr($10,Regs);
  Page := Regs.bh;
  OrigMode := Regs.al;
  { Attr }
  OrigAttr := TextAttr;
  { Kursori }
  Regs.ah := $03;
  Regs.bh := Page;
  Intr($10,Regs);
  OrigCursStart := Regs.ch;
  OrigCursStop := Regs.cl;

End;

 { ***************************************************************** }

Procedure InitScreen;
Begin

  Case Conf^.Crt.CrtMode of
    CM_Auto    : If DesqViewActive then UseDirectVideo := False;
    CM_Direct  : UseDirectVideo := True;
    CM_BIOS    : UseDirectVideo := False;
  End;

  DirectVideo := UseDirectVideo;

  CheckBreak := False;
  CheckSnow := False;

  ASM { Detect VGA display }
        mov   AX,$0F00
        int   $10
        cmp   AL,$03   { TextMode = CO80 }
        jne   @End
        mov   AX,$1C00
        mov   CX,$0007
        int   $10
        cmp   AL,$1C
        jne   @End
        mov   VGA,True { VGA display installed }
  @End:
  end { VGA display };

End;

 { ***************************************************************** }

Procedure InitWindows;
Begin

  Pal := @Conf^.Crt.Pal;

  WVideoMode;

  Case Conf^.Ifc.IfType of
    g8bpq : ActLen := 29;
    flex  : ActLen := 37;
  End;

  DirectVideo := UseDirectVideo;
  If CursorStat then SetCursorSize(CursorSize);

  ClrScr;

 { Statusikkuna }

  Window(1,1,80,1);
  TextAttr := Pal^[cmStat1];
  ClrScr;

  GotoXY(2,1);
  TextAttr := Pal^[cmStatVer];
  Write('Clusse ',Versio);

  Window(1,2,80,2);
  TextAttr := Pal^[cmStat2];
  ClrScr;

  Window(1,3,80,3);
  TextAttr := Pal^[cmStat3];
  ClrScr;

  Stat;

 { Rxikkuna }

  TextAttr := Pal^[cmRxRec];
  Window(1,4,80,RxWinLast);
  ClrScr;
  RxPos.X := WhereX;
  RxPos.Y := WhereY;

 { Monikkuna }

  If MonWinLines > 0
    then Begin
         Window(1,MonWinFirst,80,MonWinLast);
         TextAttr := Pal^[cmMonText];
         ClrScr;
         End;

 { Txikkuna }

  EditXPos := 1;
  EdWin;
  TextAttr := Pal^[cmTxWin];
  ClrScr;
  EditLn := '';

 Windowed := True;

End;

 { ***************************************************************** }

Procedure OriginalScreen;
Var Regs : Registers;
Begin

  TextMode(OrigMode);
  DirectVideo := False;
  ClrScr;
  Regs.ah := $01;
  Regs.ch := OrigCursStart;
  Regs.cl := OrigCursStop;
  Intr($10,Regs);

End;

 { ***************************************************************** }

Procedure CloseScreen;
Begin

  If Windowed then OriginalScreen;
  Windowed := False;
  TextAttr := OrigAttr;

End;

 { ***************************************************************** }

Begin { Init }

 { History }
 For ActLen := 1 to 10 do History[ActLen] := '';
 HistoryPointer := 1;
 HistoryCurrent := 2;

 { Muut muuttujat }
 InsertMode := True;
 CursorSize := Small;
 CursorStat := True;
 MonPos.Y := 1;
 Windowed := False;
 CrQueued := False;
 ConsoleMode := 0;

 StartUpTimer := HWTimer;
 Uptime := 0;

 BackUpScreenParameters;

End.

