{$F-} {$R+} {$Q+} {$I-} {$V-} {$B-} {$X-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1997

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Console;

  { Implements the keyboard handler (line editing, function keys, etc),
    console connection/disconnection, the main timer function that
    calls other timers, and an "at" facility (timed function execution,
    i don't remember if it's used or if it works at all). Also includes
    the main shutdown function. }

Interface
Var
  ConsoleSock           : Byte;      { Konsolin sukka } { Console sock }

Procedure Conn(sok:Byte);            { Connect on the console }
Procedure Disc(sok:Byte);            { Disconnect }
Procedure Recv(sok:Byte);            { Receive }

Procedure ShutDown(ErrL:Byte;Const Reason:String); { Ohjelma kumoon }

Procedure Keyboard;                  { A key has been pressed }

Procedure Timer;                     { Main timer poll }

 { ***************************************************************** }

Implementation
Uses Main, Dos, Crt, CStrings, BPQ, Screen, Files, Config, ConfFile, Linker, Protocol,
     Cluster, Convers, Unproto, MultiTsk, XMSLib;

Type
  AtQTypeP      = ^AtQType;
  AtQType       = Record
                  Time    : DateTime; { Koska suoritetaan }
                  JobType : Byte; {
                                    0   Execute procedure
                                    1   Run DOS command
                                    2   Run DOS program
                                  }
                  Proc    : Procedure;
                  JobStr  : String[30]; { Explanation }
                  Revise  : Word;       { Monenko minuutin pst uudelleen }
                  Next    : AtQTypeP;   { Jonon seuraava alkio }
                  End;

Var
  Timer_Minute   : Word;

  AtQ            : AtQTypeP;

 { ***************************************************************** }

Procedure Conn(sok:Byte);
Begin

 With Sock[sok]^
  do Begin
     Link_InActive := 0;
     Paclen := 255;
     SockMode := Raw;
     Action(69,'Connected to node (' + Int2Str(Stream[sok]) + ')');
     TextAttr := Pal^[cmRxCon];
     Display(' *** Console connected to node on stream ' + Int2Str(Stream[sok]) + Cr);
     Send(sok,'*** LINKED TO ' + Conf^.ConsoleCall + Cr);
     Kick(sok);
     Log(L_Console,'Console connected to node '+Int2Str(Stream[sok]));
     End;

End;

 { ***************************************************************** }

Procedure Disc(sok:Byte);
Begin

 Action(69,'Disconnected');
 TextAttr := Pal^[cmRxCon];
 Display(' *** Console disconnected from node' + Cr);
 ConsoleSock := 0;
 ConsoleMode := 0;
 Log(L_Console,'Console on stream '+Int2Str(Stream[sok])+' Disconnected.');

End;

 { ***************************************************************** }

Procedure Trans;
Begin

 TextAttr := Pal^[cmRxCon];
 Display(IBuffer);
 Send(ConsoleSock,IBuffer);
 Kick(ConsoleSock);

End;

 { ***************************************************************** }

Procedure Recv(sok:Byte);
Begin

 TextAttr := Pal^[cmRxRec];
 Display(IBuffer);

End;

 { ********************************************************************** }

Procedure ShutDown(ErrL:Byte;Const Reason:String);
Var
 i : Byte;

Begin { ShutDown }

  Cut_Monitor;
  Action(65,'Going down...');
  Cut_Monitor;
  UI_Down;

  TextAttr := Pal^[cmRxCon];

  If PCLinks > 0 then Protocol.CutLinks(nice,CluCall + ' shutting down.');
  AbortConnects;
  If ConsoleMode = 2 then Disconnect(ConsoleSock);

  If (LUserCount > 0) then
  Begin

  For i := 0 to UsrPorts do
    If Assigned(LUser[i])
      then Begin
           Send(i,'>>> Sorry, the system is going down.' + Cr);
           Kick(i);
           End;

  Wait(3,'Going down'); { Wait for message to get there }

  For i := 1 to UsrPorts do
    If Assigned(LUser[I])
      then Begin
           Disconnect(I);
           With LUser[i]^.f^
            do WriteLast(Call, DateStrSPad(Time) + ' ' + TimeStrS(Time)
                 + ' - ' + TimeStrS(now) + ' : ' + Secs2Str(TimeDiff(Time,Now)) + ' - Down.');
           End;

  If Assigned(LUser[0])
    then With LUser[0]^.f^
           do WriteLast(Call, DateStrSPad(Time) + ' ' + TimeStrS(Time)
                + ' - ' + TimeStrS(now) + ' : ' + Secs2Str(TimeDiff(Time,Now)) + ' - Down.');

  End;

  If PCLinks > 0 then Protocol.CutLinks(rude,'');

  Log(L_UpDown,'Shutdown. Uptime ' + Secs2Str(UpTime));
  WriteLast('Clusse',DateStrSPad(now) + ' ' + TimeStrS(now) + ' - Shutdown : '
            + Secs2Str(UpTime));

  CloseScreen;
  WriteStatus;

  Write(CrLf + ' OH7LZB Clusse ' + Versio + ' (' + CompileDate + '/' + CompiledBy + ') - Final Source Release!' + CrLf
       + CrLf
       +' ' + Copyright + CrLf
       +' ' + Licence + CrLf
       +' ' + Subcopyright + CrLf + CrLf);
  Write(' ' + Reason + CrLf + CrLf
       +' Closing interfaces....' + CrLf + CrLf);

  IfClose;
  freeAllXMS;

  Write(' Closed down.' + CrLf + CrLf);
  Halt(ErrL);

End; { ShutDown }


 { ***************************************************************** }

Procedure HelpText;
Begin

 TextAttr := Pal^[cmRxCon];
 Display(' Console keys:  Ctrl-  Alt- Ŀ' + Cr
       + ' F1   This help screen                                                 ' + Cr
       + ' F2   Console connect         Connect to node                          ' + Cr);
 Display(' F5   Toggle band monitoring  Action monitoring                        ' + Cr
       + ' F8                                              Expire files          ' + Cr
       + ' F9   Start linking           Disconnect links   Hard disconnect links ' + Cr);
 Display(' F10  Shutdown                Reboot software    Dos shell             ' + Cr
       + '' + Cr);

End;

 { ***************************************************************** }

Procedure DispTxLn;
Var s : String[80];
Begin

 s := EditLn;
 While Pos(Chr(7),s) > 0
   do s[Pos(Chr(7),s)] := Chr(14);
 TextAttr := Pal^[cmTxWin];
 DelLine;
 GotoXY(1,1);
 Write(s);

End;

 { ***************************************************************** }

Procedure Keyboard;
Var
  Ch : Char;          { Temppimerkki }
  n  : Word;

 { ***** }
 Procedure Console;
 Begin
  If ConsoleMode > 0
    then Begin
         History[HistoryCurrent] := Copy(IBuffer,1,Length(IBuffer)-1);
         Inc(HistoryCurrent);
         If HistoryCurrent = 11 then HistoryCurrent := 1;
         HistoryPointer := HistoryCurrent;
         Case ConsoleMode of

          1 : With Sock[0]^
                do Begin
                   Link_InActive := 0;
                   Usr_InActive := 0;
                   If LUser[0]^.f^.CharSet > 0
                     then IBuffer := TranslateChSet(LUser[0]^.f^.Charset,IBuffer);
                   Inc(Rx,Length(IBuffer));
                   TextAttr := Pal^[cmRxCon];
                   Display(StripBeeps(IBuffer));
                   Handle_Input(0);
                   End;

          2 : Trans;

         End; { Case Mode }
         End;
 End;
 { ***** }

 { ***** }
 Procedure WordWrap;  { Word wrapping for the input line. Damn this is UGLY now when i look at it! }
 var l : byte;
 Begin

  l := Length(EditLn);

 { Any spaces in there }
  If (Pos(' ',EditLn) = 0)
    then Begin
         Toc;
         Exit;
         End;

 { If the last character is a space }
  If (EditLn[l] = ' ')
        then Begin

              { Remove the spaces in the end }
             While (EditLn[l] = ' ') and (L > 0) do Dec(l);

              { If the line was full of spaces }
             If (l = 0) then Begin
                             IBuffer := Cr;
                             Console;
                             EditLn := '';
                             EditXPos := 1;
                             TextAttr := Pal^[cmTxWin];
                             DelLine;
                             GotoXY(1,1);
                             Exit;
                             End;

              { Send the line }
             IBuffer := Copy(EditLn,1,l) + Cr;
             Console;
             EditLn := '';
             EditXPos := 1;
             EditLn := Copy(EditLn,l,Length(EditLn)-l+1) + Ch;
             DispTxLn;
             EditXPos := Length(EditLn)+1;
             Exit;
             End;

 { Separate the last word and send the rest }

  While not ((EditLn[l] = ' ') or (l = 1)) do Dec(l); { Search for a space }

  If l = 1
    then Begin { None found! }
         Toc;
         Exit;
         End;

  While (EditLn[l] = ' ') and (l > 0) do Dec(l); { Step over the spaces }

  If l = 0
    then Begin { Oh, only spaces in the beginning! }
         Toc;
         Exit;
         End;

  IBuffer := Copy(EditLn,1,l) + Cr; { Take the beginning }

  EditLn := Copy(EditLn,l+1,Length(EditLn)-l+1); { Save the rest }
  l := 1;
  While (EditLn[l] = ' ') do Inc(l); { Remove spaces in the beginning }
  EditLn := Copy(EditLn,l,Length(EditLn)-l+1) + Ch;

  DispTxLn;
  EditXPos := Length(EditLn)+1;

  Console; { And send it out. }

 End; { WordWrap }

 { ***** }

Begin { Keyboard }

   Ch := ReadKey;

    TextAttr := Pal^[cmTxWin];

    Case Ord(CH) of

    0    : Begin
             CH := Readkey;

             Case Ord(CH) of
             45 : ShutDown(0,'ALT-X pressed.'); { ALT-X }

           { **** Funktionppimet **** }

             59 : HelpText; { F1 }

             60 : { F2: Console connect }
                  If (ConsoleMode = 0)
                    then Begin
                         ConsoleMode := 1;
                         TextAttr := Pal^[cmRxCon];
                         Display(' *** Console login'+Cr);
                         SetCursorSize(On);
                         BPQ.Login(0);
                         Cluster.Login(0);
                         End;

             95 : { CTRL-F2: Console connect to node }
                  If Conf^.Ifc.IfType = G8BPQ then
                  Case ConsoleMode of
                    0 : Begin { Connect }
                        TextAttr := Pal^[cmRxCon];
                        SetCursorSize(On);
                        ConsoleMode := 2;
                        n := 1;
                        While (n <= UsrPorts) and Assigned(Sock[n])
                         do Inc(n);
                        if n <= UsrPorts
                         then Begin
                              BPQ_Connect(n);
                              BPQ.Login(n);
                              Sock[n]^.Mode := SM_Console;
                              ConsoleSock := n;
                              End
                         else Display(' *** No streams available.' + Cr);
                        End;
                    2 : Begin { Disconnect }
                        Disconnect(ConsoleSock);
                        End;
                  End;

             63 : Begin { F5 }
                  Toggle_Monitor;
                  Stat;
                  End;

             98 : Begin { CTRL-F5 }
                  If MO_Actions in Conf^.Ifc.MonitorMode
                    then Exclude(Conf^.Ifc.MonitorMode,MO_Actions)
                    else Include(Conf^.Ifc.MonitorMode,MO_Actions);
                  Stat;
                  End;


{             110 : RunError(255);} { alt-f7 }

{             101 : ImportDx;} { CTRL-F8 }

             111 : StartExpiry;

             67  : Begin { F9 }
                   Protocol.StartLinks;
                   End;

             102 : Begin { CTRL-F9 }
                   Protocol.CutLinks(nice,'Forced disconnection at ' + CluCall);
                   Linker.AbortConnects;
                   End;

             112 : Begin { Alt-F9 }
                   Protocol.CutLinks(rude,'');
                   Linker.AbortConnects;
                   End;

             68  : Shutdown(0,'F10 pressed.');
             103 : Shutdown(100,'CTRL-F10 pressed - reboot.');
             113 : DosShell; { Alt-F10 }

           { **** **** }

             71 : Begin { Home }
                  GotoXY(1,1);
                  EditXPos := 1;
                  End;

             79 : Begin { End }
                    EditXPos := Length(EditLn)+1;
                    GotoXY(EditXPos,1);
                  End;

             82 : Begin { Ins }
                    InsertMode := NOT InsertMode;
                    Stat;
                    If InsertMode then SetCursorSize(Small)
                                  else SetCursorSize(Big);
                  End;

             83 : Begin { Del }
                    Delete(EditLn,EditXPos,1);
                    DispTxLn;
                    GotoXY(EditXPos,1);
                  End;

             72 : Begin { Cursor up - History }
                    If HistoryPointer = HistoryCurrent
                      then History[HistoryCurrent] := EditLn;
                    Dec(HistoryPointer);
                    If HistoryPointer = 0 then HistoryPointer := 10;
                    EditLn := History[HistoryPointer];
                    EditXPos := Length(EditLn) + 1;
                    DispTxLn;
                    GotoXY(EditXPos,1);
                  End;

             80 : Begin { Cursor down - History }
                    If HistoryPointer = HistoryCurrent
                      then History[HistoryCurrent] := EditLn;
                    Inc(HistoryPointer);
                    If HistoryPointer = 11 then HistoryPointer := 1;
                    EditLn := History[HistoryPointer];
                    EditXPos := Length(EditLn) + 1;
                    DispTxLn;
                    GotoXY(EditXPos,1);
                  End;

             77 : If ((EditXPos < 80) and (EditXPos < Length(EditLn) +1))
                    then Begin { Cursor right }
                         Inc(EditXPos);
                         GotoXY(EditXPos,1);
                         End
                    else Toc;

             75 : If EditXPos > 1
                    then Begin { Cursor left }
                         Dec(EditXPos);
                         GotoXY(EditXPos,1);
                         End;

             115: { CTRL-Cursor left - Word left }

                  If (EditXPos > 1)
                   then Begin
                        n := EditXPos;
                        If EditLn[n-1] = ' ' then repeat Dec(n) until (N=1) or (EditLn[n] <> ' ');
                        If N > 0 then repeat Dec(n) until (n = 0) or (EditLn[n] = ' ');
                        If n > 0 then EditXPos := N+1;
                        If n = 0 then EditXPos := 1;
                        GotoXY(EditXPos,1);
                        End;

             116: { CTRL-Cursor right - Word right }

                  If ((EditXPos < 80) and (EditXPos < Length(EditLn)))
                   then Begin
                        n := EditXPos;
                        Repeat Inc(n);
                        until (n > Length(EditLn) +1) or (EditLn[n] = ' ');
                        If n < Length(EditLn)+1 then
                        Repeat Inc(n);
                        until (n > Length(EditLn)+1) or (EditLn[n] <> ' ');
                        If n < Length(EditLn)+2 then EditXPos := N;
                        GotoXY(EditXPos,1);
                        End;

             118: EdWinDown; { CTRL-Page down }

             132: EdWinUp; { CTRL-Page up }

{ Scancoden lytmiseksi:
             else Display(Int2Str(Ord(Ch)) + Cr);
}
             End;

           End;


    8    : IF EditXPos > 1
             then Begin                                { Backspace key }
                  Dec(EditXPos);
                  Delete(EditLn,EditXPos,1);
                  DispTxLn;
                  GoToXY(EditXPos,1);
                  End;

    25,27 : Begin                                { CTRL-Y, Esc }
             DelLine;
             EditLn := '';
             EditXPos := 1;
             GotoXY(1,1);
           End;

    13   : Begin                                { Enter key }
             IBuffer := EditLn + CR;
             EditXPos := 1;
             DelLine;
             EditLn := '';
             GotoXY(1,1);
             Console;
           end;

    1..7, 9, 11..12, 14..27, 28..31,
        32..126, 128..165, 171..172 :   { Kirjain }

       If ConsoleMode > 0 then
        If InsertMode
           then If Length(EditLn) = 79
                   then WordWrap
                   else Begin
                        Insert(Ch,EditLn,EditXPos);
                        Inc(EditXPos);
                        DispTxLn;
                        GotoXy(EditXPos,1);
                        End

           Else If EditXPos = 79
                   then WordWrap
                   else Begin
                        If EditXPos = Length(EditLn)+1
                           then EditLn := EditLn + Ch
                           else EditLn[EditXPos] := Ch;
                        DispTxLn;
                        Inc(EditXPos);
                        GotoXY(EditXPos,1);
                        End;

    end;    { Case }

End;

 { ***************************************************************** }

Procedure At; { Timed execution }
Var
  Prev : ^AtQTypeP;
  Next,
  AtP  : AtQTypeP;
Begin

 Prev := @AtQ;
 AtP := AtQ;

 While assigned(AtP)
  do Begin
     Next := AtP^.Next;
     If DTimeDiff(Dt,Atp^.Time) <= 0
       then Case Atp^.JobType of
             0 : Atp^.Proc;
            End;
     AtP := Next;
     End;

End;

 { ***************************************************************** }
 { Pivitt laskurit yms - kutsutaan joka kierroksella Main:sta     }

Procedure Timer;
Var
 Hund, Second : Word;
Begin

 WatchTimer := 0; { Resetoi watchdog }
 GetTime(Dt.Hour,Dt.Min,Second,Hund);

 If (Dt.Sec <> Second)
  then Begin
       Dt.Sec := Second;
       ClockUpDate;
       BPQ.SecTimer;
       Cluster.SecTimer;
       Protocol.SecTimer;
       Linker.SecTimer;

       If (Timer_Minute <> Dt.Min)
         then Begin
              BPQ.MinTimer;
              Protocol.MinTimer;
              { Conv linkkaus toistaiseksi pois, disable conversd linking for now
              Convers.Timer;
              }
              Linker.MinTimer;
              Files.MinTimer;
              At;

              Timer_Minute := Dt.Min;
              End;

       End;

End;

 { ***************************************************************** }

Begin

  Timer_Minute := 61;

End.
