
Unit s_Scr;

Interface

Uses Drivers, Objects, Views, Dialogs, Strings, Validate, ConfFile, SetForm;

Type

   { Screen parameters }

  PCrtType = ^TCrtType;
  TCrtType = object(TRadioButtons)
    constructor Init(var Bounds: TRect; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PCrtMode = ^TCrtMode;
  TCrtMode = object(TRadioButtons)
    constructor Init(var Bounds: TRect; AStrings: PSItem);
    destructor Done; virtual;
  end;

  PScr = ^TScr;
  TScr = object(TDialog)
    Backup      : PConfig;
    Abandon     : Boolean;
    Usr_Timeout : PWordEntry;

    CrtType     : PCrtType;
    CrtMode     : PCrtMode;

    constructor Init;
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

Const
  RScr: TStreamRec = (
     ObjType: 10048;
     VmtLink: Ofs(TypeOf(TScr)^);
     Load:    @TScr.Load;
     Store:   @TScr.Store
  );

Procedure RegisterScrForm;

Implementation { ********************************************************* }

Uses
  MsgBox;

 { *** TCrtType *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TCrtType.Init(var Bounds: TRect; AStrings: PSItem);
Var i : LongInt;
Begin

 inherited Init(Bounds, AStrings);
 i := Conf^.Crt.CrtType;
 SetData(i);

End;

Destructor TCrtType.Done;
Begin

 Conf^.Crt.CrtType := Value;
 inherited Done;

End;

 { *** TCrtMode *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TCrtMode.Init(var Bounds: TRect; AStrings: PSItem);
Var i : LongInt;
Begin

 inherited Init(Bounds, AStrings);
 i := Ord(Conf^.Crt.CrtMode);
 SetData(i);

End;

Destructor TCrtMode.Done;
Begin

 Move(Value,Conf^.Crt.CrtMode,1);
 inherited Done;

End;

 { *** TScr *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TScr.Init;
Var
  R : TRect;
Begin

  R.Assign(0, 0, 35, 16);
  inherited Init(R,'Screen settings');

  R.Assign(4, 3, 31, 7);
  CrtType := New(PCrtType, Init(R,
    NewSItem('~2~5 lines',
    NewSItem('43/~5~0 lines (EGA/VGA)',
    NewSItem('2~8~ lines (VGA)',
    NewSItem('~4~3 lines on a VGA',nil))))));
  Insert(CrtType);

  R.Assign(2, 2, 15, 3);
  Insert(New(PLabel, Init(R, 'Screen ~s~ize:', CrtType)));

  R.Assign(4, 9, 31, 12);
  CrtMode := New(PCrtMode, Init(R,
    NewSItem('~A~utomatic',
    NewSItem('Force ~d~irect',
    NewSItem('Force ~B~IOS', nil)))));
  Insert(CrtMode);

  R.Assign(2, 8, 15, 9);
  Insert(New(PLabel, Init(R, 'I/O ~m~ode:', CrtMode)));

  R.Assign(6, 13, 16, 15);
  Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
  Inc(R.A.X, 12); Inc(R.B.X, 12);
  Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

  SelectNext(False);
  Options := Options or ofCentered or OfSelectable;
  EventMask := evKeyDown + evCommand + evBroadcast;
  Abandon := False;
  New(Backup);
  Backup^ := Conf^;

End;

Destructor TScr.Done;
Begin

 inherited Done;

 If Abandon
   then Begin
        Dispose(Conf);
        Conf := Backup;
        End
   else Dispose(Backup);

End;

Constructor TScr.Load(var S: TStream);
Begin
  inherited Load(S);
End;

Procedure TScr.HandleEvent(var Event: TEvent);
Begin

  Case Event.What of
    evCommand: Case Event.Command of
                 cmCancel : Abandon := True;
               End;
  End;
  inherited HandleEvent(Event);

End;

Procedure TScr.Store(var S: TStream);
Begin
  TView.Store(S);
{  S.Write(Status, SizeOf(Status) + SizeOf(Number) + SizeOf(Sign) +
    SizeOf(Operator) + SizeOf(Operand));}
End;


Procedure RegisterScrForm;
Begin
  RegisterType(RScr);
End;

End.
