{$F-} {$R+} {$Q+} {$V-} {$B-} {$X-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit cmd_Sys;

  { Implements some user commands which fall in the "system" class,
    including things like system status queries, version queries,
    "sysop-only" commands, user file editing, etc. }

Interface
Uses Cluster;

Procedure LErrors_Cmd(p:sType);
Procedure MemStat_Cmd(p:sType);
Procedure Status_Cmd(p:sType);
Procedure SU_Cmd(p:sType);
Procedure Disc_Cmd(p:sType);
Procedure Reboot_Cmd(p:sType);
Procedure Shutdown_Cmd(p:sType);
Procedure EGroup_Cmd(p:sType);
Procedure Groups_Cmd(p:sType);
Procedure EUser_Cmd(p:sType);
Procedure PRivileges_Cmd(p:sType);
Procedure Software_Cmd(p:sType);
Procedure GPL_Cmd(p:sType);

Procedure EGroup_Response(p:Byte);
Procedure EUser_Response(p:Byte);
Procedure SU_Response(p:Byte);
Procedure Reboot_Response(p:Byte);
Procedure Shutdown_Response(p:Byte);

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Implementation
Uses Crt, BPQ, Protocol, Files, cStrings, Screen, Linker, Multitsk, xmsLib,
     Console, Database, ConfFile, Config, Filters;
Type
  Char16TableP  = ^Char16Table;
  Char16Table   = Array[0..15] of Char;
Const
  FlagCharTable  : Char16Table = 'btrpf???????????';
  MessCharTable  : Char16Table = 'dawetulni???????';
  LoginCharTable : Char16Table = 'dawunif?????????';

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure LErrors_Cmd(p:sType);
Var
  w : Word;
Begin

  w := Str2Word(Parse(1));
  If (w > 500) then w := 500;
  If w = 0 then w := 20;
  Action(p,'List errors');
  SendFileTail(p,LogPath + 'error.log',w);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure MemStat_Cmd(p:Byte);
Var
 TotalUsed : LongInt;
 Eol       : Boolean;

 Procedure Entry(Usage:String; Amount:Word; RecLen:Word);
 Var
  Used : LongInt;
 Begin
  Used := RecLen * Amount;
  Inc(TotalUsed,Used);
  Send(p,Usage + PadRight(6,Int2Str(Used)) + ' (');
  If Eol
    then Send(p,Int2Str(Amount) + ')' + Cr)
    else Send(p,PadLeft(6,Int2Str(Amount) + ')'));
  Eol := not Eol;
 End;

Begin

 TotalUsed := 0;
 Eol := False;

 Action(p,'Status - memory');
 Send(p,'Memory usage: ' + Int2Str(MemAvail) + ' bytes free, largest block ' + Int2Str(MaxAvail)
                         + ' bytes.' + Cr
      + ' --- Dynamic data' + Cr);

 Entry(' User table:   ', KUserCount, SizeOf(NUserRec));
 Entry(' Node table:   ', NodeCount, SizeOf(NodeRec));
 Entry(' Local users:  ', LUserCount, SizeOf(LUserRec) + SizeOf(LUserFRec));
 Entry(' BPQ sockets:  ', BPQSocks, SizeOf(SocketType));
 Entry(' Linker jobs:  ', LinkJobs, SizeOf(LinkJobRec));
 Entry(' Pinger jobs:  ', PingJobs, SizeOf(PingRec));
 Entry(' rem. DB jobs: ', RDbJobs, 28);
 Entry(' lAway strs:   ', LAwayStrings, SizeOf(tAwayString));
 Entry(' nAway strs:   ', NAwayStrings, SizeOf(tAwayString));
 Entry(' DX Filters:   ', FiltersM, SizeOf(FlRec));

 Send(p,' --- Static data' + Cr);
 Eol := False;

 Entry(' PC links:     ', PCLinksC, SizeOf(LinkRec));
 Entry(' Databases:    ', 1, DBConfigMem);
 Entry(' Char tables:  ', CharSets, SizeOf(CharTableRec));
 Entry(' MID table:    ', 1, MidTableMem);
 Entry(' Login text:   ', 1, LoginTextLen);
 Entry(' News:         ', NewsArticles, SizeOf(NewsQType));
 Entry(' Other static: ', 1, OtherStaticMem);

 Send(p,Cr + ' ----------------------' + Cr
      + ' Other:        ' + PadRight(6,Int2Str(HeapUsed - TotalUsed)) + ' b' + Cr
      + ' ----------------------' + Cr
      + ' Total:        ' + PadRight(6,Int2Str(HeapUsed)) + ' b' + Cr);

End;


 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Status_Cmd(p:Byte);
Var
  Param : String;
  i     : LongInt;
Begin

 Param := Parse(1);

 If (Length(Param) > 0)
  then Case LowCaseCh[Param[1]] of

     '%','d': Begin { Debug information }
              Action(p,'Status - debug');
              Send(p,'Debug information:' + Cr
                   + 'OS:  ');
              If OS2Active
                then Send(p, 'OS/2 ' + OS2VerStr)
                else Send(p, 'DOS ' + Int2Str(Lo(DosVer)) + '.' + Int2Str(Hi(DosVer)));
              If DesqViewActive then Send(p,', DesqView v' + DesqViewVerStr);
              If WindowsActive then Send(p,', Windows ' + WindowsVerStr + ' (' + WindowsModeStr + ')');
              If DPMIActive then Send(p,', DPMI v' + DPMIVerStr);
              Send(p,Cr + 'Mem: Heap free ' + Int2Str(MemAvail) + ' b, largest free block '
                   + Int2Str(MaxAvail) + ' b, used ' + Int2Str(HeapUsed) + ' b' + Cr
                   + '     min free ' + Int2Str(HeapMinFree) + ' b, min largest ' + Int2Str(HeapMinFreeMax) + ' b, '
                   + Int2Str(HeapAllocs) + ' allocs' + Cr);
              If XMSPresent then
                 Send(p,'XMS: Version ' + PrintXMSVersion + ', XMM ' + PrintXMMVersion + '. '
                      + Int2Str(XMSTotalFreeMemory) + ' KB free, largest block '
                      + Int2Str(XMSLargestBlock) + ' KB. ' + Cr
                      + '     ' + Int2Str(XMSUsed) + ' KB used by Clusse for '
                      + Int2Str(xmsHandles) + ' handles.' + Cr);

              Case Conf^.Ifc.IfType of

                G8BPQ : Send(p,'BPQ: v' + IfVersion + ', str ' + Int2Str(Conf^.Ifc.Start_port+1) + '-'
                             + Int2Str(Conf^.Ifc.Start_port + Conf^.Ifc.No_ports)
                   + ' (' + Int2Str(Conf^.Ifc.No_ports) + '), int ' + Int2Str(Conf^.Ifc.BpqInt)
                   + ', appl ' + Int2Str(Conf^.Ifc.ApplNum) + Cr
                   + '     buf ' + Int2Str(IfBuffers) + ', lowest ' + Int2Str(MinBuf) + ', highest ' + Int2Str(MaxBuf)
                   + ', ');
                Flex : Send(p, 'PC/FlexNet: v' + IfVersion + ', max ' + Int2Str(Conf^.Ifc.No_ports)
                            + ' users, ');
              End;
              Send(p,'tx ' + Int2Str(BPQ.FrSent) + ' rx '  + Int2Str(BPQ.FrRec) + ' mon '
                   + Int2Str(BPQ.FrMon) + ' frames' + Cr);


              If Watchdog
                then Send(p,'Watchdog: Running, max ' + Int2Str(WatchMax) + ', reboot at ' + Int2Str(WatchResetT) + ' ('
                          + Int2Str(WatchResetS) + ' sec).' + Cr);

              Send(p,'Uptime: ' + Secs2Str(UpTime) + ' - since ' + DateStrS(StartUpTime) + ' '
                   + TimeStrL(StartUpTime) + Cr
                   + 'Logins: ' + Int2Str(LoginCount) + ', Max users ' + Int2Str(MaxUsers)
                   + ', locals ' + Int2Str(MaxLUsers) + ', nodes ' + Int2Str(MaxNodes) + Cr);
{              Send(p,'HWTimer: ' + DW2Str(HWTimer) + ', startup ' + DW2Str(StartUpTimer)
                   + ', up ' + Secs2Str(HWUpTime) + ' (just an experiment!)' + Cr);}
              End; { Debug information }

         'm': MemStat_Cmd(p);        { Memory status }
         'b': DbStatus_Cmd(p);       { Database status }
         'f': FileStatus_Cmd(p);     { File system status }
         'l': Begin
              Action(p,'Status - Links');
              Send(p,'Cluster links:' + Cr);
              Linklist_Cmd(p);       { Link status }
              End;
         'p': ProtocolStatus_Cmd(p); { Protocol Status }
         'r': RdbStatus_Cmd(p);      { Remote database status }
         'x': Begin { XMS status }
              Action(p,'Status - XMS');
              xmsStatus_Cmd(p);
              End;

       Else Send(p,'Illegal parameter.' + Cr);
       End { Case }
  else BPQ.Socketlist_Cmd(p);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Attempt to become SuperUser }

Procedure SU_Cmd(p:Byte);
Var
  b      : Byte;
  Wanted : LongInt;
  Pos    : Byte;
Begin

 Action(p,'Tries SU');
 Wanted := 1;
 For b := 1 to 5
   do Begin
      Pos := Random(Conf^.Adm.SysopSecretNumber[0]) + 1;
      Wanted := Wanted * Conf^.Adm.SysopSecretNumber[Pos];
      Send(p,' ' + Int2Str(Pos));
      End;

  Pos := Random(Conf^.Adm.SysopSecretNumber[0]) + 1;
  Wanted := Wanted + Conf^.Adm.SysopSecretNumber[Pos];
  Send(p,' ' + Int2Str(Pos));

 Send(p,Cr);
 LUser[p]^.Str := Int2Str(Wanted) + Cr;
 LUser[p]^.M2 := 2;
 Prompted := False;

End;

Procedure SU_Response(p:Byte);
Begin

 With LUser[p]^ do Begin

 If (R_suCMD in Conf^.Groups[Group].Rights) and (IBuffer = Str) and (SUTries < 3)
   then Begin { Onneksi olkoon! }
        Group := 20;
        SUTries := 0;
        Send(p,'OK.' + Cr);
        Log(L_SU,f^.Call + ' SU accepted.');
        Action(p,'Gained SuperUser access');
        End
   else Begin { Oijoi. }
        If SUTries < 3
          then Inc(SUTries);
        Group := f^.Group;
        Send(p,'Sorry.' + Cr);
        Log(L_SU,f^.Call + ' SU failed.');
        Action(p,'Failed SU');
        End;

 M2 := 0;

 End; { With .... }
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Disc_Cmd(p:Byte);
Var
  so   : Byte;
  s    : CallRec;
  l    : LinkRecP;
Begin

 s := UpCaseStr(Parse(1));
 so := GetLUser(s);
 If so = 255
   then Begin
        l := GetLink(s);
        If assigned(l)
          then so := l^.Sock
          else so := 255;
        End;

 If so < SockMax
  then If Assigned(Sock[so])
         then If so <> p
                then Begin
                     Action(p,'Disconnects stream ' + Int2Str(Stream[so]));
                     Send(p,'Disconnecting stream ' + Int2Str(Stream[so]) + '.' + Cr);
                     BPQ.Disconnect(so);
                     End
                else Send(p,'Sorry, you cannot disconnect yourself.' + Cr)
         else Send(p,'Stream ' + Int2Str(so) + ' not connected.' + Cr)
  else Send(p,'Stream not used or user/node not connected.' + Cr);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Reboot_Cmd(p:Byte);
Begin

 With LUser[p]^ do Begin

 If LowCaseStr(Parse(1)) = 'warm'
  then Begin
       Action(p,'Requesting warm reboot');
       Send(p,'Warm reboot the computer (Yes/NO)?' + Cr);
       M3 := 1
       End
  else If LowCaseStr(Parse(1)) = 'cold'
       then Begin
            Action(p,'Requesting cold reboot');
            Send(p,'Cold reboot the computer (Yes/NO)?' + Cr);
            M3 := 2
            End
       else Begin
            Action(p,'Requesting software reboot');
            Send(p,'Reboot software (Yes/NO)?' + Cr);
            M3 := 0;
            End;

 M2 := 3;
 Prompted := False;

 End; { With... }

End;

Procedure Reboot_Response(p:Byte);
Var
  b : Byte;
  s : String[4];
Begin

 With LUser[p]^ do
 If LowCaseStr(IBuffer) = 'yes' + Cr
  then Case M3 of
         0   : Begin
               Send(p,'Rebooting software...' + Cr);
               Kick(p);
               Log(L_UpDown,f^.Call + ' Software reboot');
               ShutDown(100,'Remote reboot by ' + f^.Call + '.');
               End;
         1,2 : Begin
               If M3 = 1
                 then s := 'Warm'
                 else s := 'Cold';
               Action(p,s + ' rebooting the computer');
               Log(L_UpDown,f^.Call + s + ' reboot');
               Send(p,s + ' rebooting the computer in 15 seconds.' + Cr);
               Kick(p);
               Cut_Monitor;
               FlushCaches;
               Delay(1);
               IfClose;
               Wait(15,s + ' rebooting');
               If M3 = 1
                 then Reboot(warm)
                 else Reboot(cold);
               End;
       End
  else Begin
       Action(p,'Cancelled reboot');
       Send(p,'Reboot cancelled.' + Cr);
       M2 := 0;
       End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Shutdown_Cmd(p:Byte);
Begin

 Action(p,'Requesting shutdown');
 Send(p,'Shutdown (Yes/NO)?' + Cr);
 LUser[p]^.M2 := 4;
 Prompted := False;

End;

Procedure Shutdown_Response(p:Byte);
Begin

 With LUser[p]^ do Begin
 If LowCaseStr(IBuffer) = 'yes' + Cr
  then Begin
       Send(p,'Shutting down...' + Cr);
       Kick(p);
       Log(L_UpDown,f^.Call + ' Remote shutdown.');
       ShutDown(0,'Remote shutdown by ' + f^.Call + '.');
       End
  else Begin
       Action(p,'Cancelled shutdown');
       Send(p,'Shutdown cancelled.' + Cr);
       End;
 M2 := 0;

 End; { With... }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { EUser, EGroup                                                           }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure SendGroupInfo(p,b:Byte);
Begin

 With Conf^.Groups[b] do
        {12: 123456789012345 }
 Send(p,'    Name' + Cr
      + PadLeft(4,Int2Str(b) + ':') + Name + Cr);


End;

Procedure GroupList(p:Byte);
Var b : Byte;
Begin

 For b := 1 to GroupsAvail
  do With Conf^.Groups[b] do
     If Used
       then Send(p,'  ' + PadLeft(4,Int2Str(b) + ':') + PadLeft(16,Name)
                 + Cr);

End;

Procedure EGroup_Cmd(p:Byte);
Begin

 With LUser[p]^ do Begin

 MTimer := Str2Word(Parse(1));

 If (MTimer > 0) and (MTimer <= GroupsAvail)
   then Begin
        Action(p,'Edit group ' + Int2Str(MTimer));
        M2 := 8;
        If Conf^.Groups[MTimer].Used
          then Begin
               M3 := 0;
               SendGroupInfo(p,MTimer);
               End
          else Begin
               Send(p,'Group ' + Int2Str(MTimer) + ' is disabled. Enable (y/N)?' + Cr);
               M3 := 1;
               End;
        Prompted := False;
        End
   else Begin
        Send(p,'No such group. Groups available:' + Cr);
        GroupList(p);
        End;

 End; { With... }

End;

Procedure EGroup_Response(p:Byte);
Var
  Del : Boolean;
Begin

 With LUser[p]^ do
 Case M3 of

  0 : If (IBuffer = Cr)
        then M2 := 0
        else Begin
             Action(p,'Editing group ' + Int2Str(MTimer));
             Del := False;
             Case LowCaseCh[IBuffer[1]] of
              'd' : Del := True; { Disable }
              'h' : Begin
                    Help(p,'egroup');
                    Send(p,'---' + Cr);
                    End;
             End;

             If Del
               then Begin
                    Action(p,'Group ' + Int2Str(MTimer) + ' disabled.');
                    Send(p,'Group ' + Int2Str(MTimer) + ' disabled. You can no more place new users in this group, but' + Cr
                         + 'the users currently in the group are stay there until you move them.' + Cr);
                    Conf^.Groups[MTimer].Used := False;
                    M2 := 0;
                    End
               else Begin
                    Prompted := False;
                    SendGroupInfo(p,MTimer);
                    End;
             End;

  1 : Begin
      M3 := 0;
      If LowCaseCh[IBuffer[1]] = 'y'
       then Begin { create }
            Conf^.Groups[MTimer].Used := True;
            Prompted := False;
            Action(p,'Group ' + Int2Str(MTimer) + ' enabled.');
            Send(p,'Group ' + Int2Str(MTimer) + ' enabled.' + Cr);
            SendGroupInfo(p,MTimer);
            End
       else M2 := 0;
      End;

 End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure GroupRights(p,gr:Byte);
Var
  s : String;
  b : Byte;
  w : Word;

Const

  RStrings : Array [1..10] of String[16]
           = ('Login', 'ARES login', 'Interact', 'Wide-area i-a',
              'ARES control',  'Link control', 'Node control',
              'SuperUser access', 'All commands', 'Never expire');

  fRStrings : Array [1..9] of String[16]
            = ('File commands', 'All files', 'Wr/incoming dir',
               'Wr/user dir', 'Wr/everywhere', 'PG', 'Run/user dir',
               'Run/everywhere', 'DOS');

Begin

 With Conf^.Groups[gr]
      do Begin

         s := '';
         w := 1;
         b := 1;

         Repeat
           If w and Word(Rights) = w
             then s := s + ', ' + RStrings[b];
           w := w shl 1;
           Inc(b);
         until b = 11;
         Delete(s,1,2);

         w := 1;
         b := 1;
         Repeat
           If w and Word(fRights) = w
             then s := s + ', ' + fRStrings[b];
           w := w shl 1;
           Inc(b);
         until b = 10;

         End;

 Send(p,Format(True,'  ',s));

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Groups_Cmd(p:sType);
Var
  b : Byte;
Begin

 b := Str2Byte(Parse(1));
 Action(p,'Groups');
 If (b = 0) or (b > 20)
   then Begin
        Send(p,'Privilege groups:' + Cr);
        GroupList(p);
        End
   else Begin
        Send(p,'Privilege flags for group ' + Int2Str(b) + ':' + Cr);
        If not Conf^.Groups[b].Used
          then Send(p,'  Group disabled.' + Cr)
          else GroupRights(p,b);
        End;
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Function FlagChars(w:pByte;Chars:Char16TableP):String;
Var
  b  : Byte;
  ww : Word;
  s  : String[8];
Begin

 s := '';
 For b := 0 to 7
  do Begin
     ww := Raise(2,b);
     If w^ and ww = ww
       then s := s + Chars^[b];
     End;

 FlagChars := s;

End;

Function MsgChars(w,bw:pWord):String;
Var
  b  : Byte;
  ww : Word;
  s  : String[16];
Begin

 s := '';
 For b := 0 to 15
  do Begin
     ww := Raise(2,b);
     If w^ and ww = ww
       then If bw^ and ww = ww
              then s := s + UpCaseCh[MessCharTable[b]]
              else s := s + MessCharTable[b];
     End;

 MsgChars := s;

End;

Procedure SendLUserInfo(p:Byte;fp:LUserFP);
Begin

 With fp^ do
       { OH7LZB 123456 00/00 0000Z 12 1234567890123 123 123 12345 dawuhetli dawunif}
 Send(p,'Call   Logins Last login  User group       Pro Chr Flags Messages  Login' + Cr
      + PadLeft(7,Call)
      + PadLeft(7,Int2Str(Logins)) + DateStrSPad(Time)
      + ' ' + TimeStrS(Time) + 'Z ' + PadLeft(3,Int2Str(Group))
      + PadLeft(14,Conf^.Groups[Group].Name)
      + PadLeft(4,Int2Str(Prompt))
      + PadLeft(4,Int2Str(Charset)) + PadLeft(6,FlagChars(@Flags,@FlagCharTable))
      + PadLeft(10,MsgChars(@Messages,@Beeps)) + FlagChars(@LoginAct,@LoginCharTable) + Cr);

End;

Procedure EUser_Cmd(p:Byte);
Var
  fp : LUserFP;
Begin

 With LUser[p]^ do Begin

 Str := UpCaseStr(StripSSID(Parse(1)));
 Action(p,'Edit user ' + Str);
 If (Str = '')
   then Send(p,'Syntax: EUser call' + Cr)
   else Begin
        fp := ReadUser(Str);
        M2 := 5;
        If assigned(fp)
          then Begin
               If not (GetLUserS(Str) = 255)
                 then Send(p,'User is connected, modifying settings in real time. Be warned.' + Cr);
               M3 := 0;
               SendLUserInfo(p,fp);
               Dispose(fp);
               End
          else Begin
               Send(p,'User ' + Str + ' not found. Create (y/N)?' + Cr);
               M3 := 1;
               End;
        Prompted := False;
        End;
 End; { With... }
End;

Procedure EUser_Response(p:Byte);
Var
  fp   : LUserFP;
  del  : Boolean;
  b    : Byte;
  s    : String[16];

  Procedure EU_Flags(var Flags;Chars:Char16TableP);
  Var
    b  : Byte;
    po : Byte;
    s  : String;
  Begin

   s := LowCaseStr(Parse(1));

   For b := 1 to Length(s)
   do Begin
      po := Pos(s[b],Chars^);
      If po > 0
        then Word(Flags) := Word(Flags) xor Raise(2,po-1);
      End;

  End;

Begin

 With LUser[p]^ do
 Case M3 of

  0 : Begin
      Del := False;
      fp := ReadUser(str);
      If (IBuffer = Cr) or (not assigned(fp))
        then M2 := 0
        else Begin
             Action(p,'Editing user ' + fp^.Call);
             Case LowCaseCh[IBuffer[1]] of
              'b' : EU_Flags(fp^.Beeps,@MessCharTable);
              'c' : Begin { Charset }
                    b := Str2Byte(Parse(1));
                    If (b = 0) or ((b >= 1) and (b <= 5) and (CharSet[b] <> nil))
                      then fp^.CharSet := b;
                    End;
              'd' : If GetLUserS(Str) = 255
                     then Del := True { Delete }
                     else Send(p,'User connected, cannot delete. Disconnect him/her first.' + Cr);

              'f' : EU_Flags(fp^.Flags,@FlagCharTable);

              'g' : Begin
                    b := Str2Byte(Parse(1));
                    If (b > 0) and (b <= GroupsAvail)
                      then If Conf^.Groups[b].Used
                             then fp^.Group := b
                             else Send(p,'Group ' + Int2Str(b) + ' is disabled.' + Cr)
                      else Begin
                           Send(p,'No such group. Groups available:' + Cr);
                           GroupList(p);
                           End;
                    If b = 20
                      then Send(p,'You REALLY should not place an user to the superuser group!' + Cr);
                    End;

              'l' : EU_Flags(fp^.LoginAct,@LoginCharTable);
              'm' : EU_Flags(fp^.Messages,@MessCharTable);

              'p' : Begin { Prompt }
                    b := Str2Byte(Parse(1));
                    If b <= PromptsAvail then fp^.Prompt := b;
                    End;
              't' : fp^.Time := now;
              '?',  { Help }
              'h' : Begin
                    Help(p,'euser');
                    Send(p,'---' + Cr);
                    End;
             End;
             If Del
               then Begin
                    Action(p,'Deleted user ' + fp^.Call);
                    Send(p,'Deleted.' + Cr);
                    M2 := 0;
                    End
               else Begin
                    SendLUserInfo(p,fp);
                    WriteUser(fp);
                    Prompted := False;
                    End;
             End;

      If Del
        then DelUser(Str)
        else Begin
             For b := 0 to UsrPorts
              do If Assigned(LUser[b]) and (StripSSID(LUser[b]^.f^.Call) = Str)
                   then Begin
                        s := LUser[b]^.f^.Call;
                        LUser[b]^.f^ := fp^;
                        LUser[b]^.f^.Call := s;
                        Sock[b]^.CharSet := fp^.CharSet;
                        LUser[b]^.Group := fp^.Group;
                        End;
             End;

      If Assigned(fp)
        then Dispose(fp)
        else Send(p,'User ' + Str + ' not found.' + Cr);

      End;

  1 : Begin
      M3 := 0;
      If LowCaseCh[IBuffer[1]] = 'y'
       then Begin { create }
            New(fp);
            LUserFDefaults(fp);
            fp^.Call := Str;
            WriteUser(fp);
            Prompted := False;
            Action(p,'Created user entry for ' + fp^.Call);
            Send(p,'Created user entry:' + Cr);
            SendLUserInfo(p,fp);
            Dispose(fp);
            End
       else M2 := 0;
      End;
 End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Privileges_Cmd(p:sType);
Begin

 Action(p,'Privileges');
 With LUser[p]^
  do Begin
     Send(p,'Your privilege group: ' + Int2Str(f^.Group) + ': ' + Conf^.Groups[f^.Group].Name);
     If Group <> f^.Group
       then Send(p,' (effective group ' + Int2Str(group) + ': ' + Conf^.Groups[group].Name + ')');
     Send(p,Cr + ' Privilege flags:' + Cr);
     GroupRights(p,group);
     End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Software_Cmd(p:sType);
Begin

 Action(p,'Software information');
 Send(p,'Software information:' + Cr + Cr
      + ' OH7LZB Clusse ' + Versio + ' (' + CompileDate + '/' + CompiledBy + ') '
        + Processor {$IFDEF debug} + '-Debug' {$ENDIF}
        + ' - Final Source Release!' + Cr
      + ' A free DX Cluster/Conference system for amateur radio use only.' + Cr + Cr
      + '   See http://zone.pspt.fi/clusse/ - The Home of Clusse on Internet.' + Cr + Cr);
 Send(p,' ' + Copyright + Cr
      + ' ' + Licence + Cr
      + ' ' + Subcopyright + Cr + Cr);
 Send(p,'See the GPL command for the licence declaration.' + Cr);
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure GPL_Cmd(p:sType);
Const
  GPL1 = ' This program is free software; you can redistribute it and/or modify' + Cr
       + ' it under the terms of the GNU General Public License as published by' + Cr
       + ' the Free Software Foundation; either version 2 of the License, or' + Cr
       + ' (at your option) any later version.' + Cr + Cr;
  GPL2 = ' This program is distributed in the hope that it will be useful,' + Cr
       + ' but WITHOUT ANY WARRANTY; without even the implied warranty of' + Cr
       + ' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the' + Cr
       + ' GNU General Public License for more details.' + Cr + Cr;
  GPL3 = ' You should have received a copy of the GNU General Public License' + Cr
       + ' along with this program; if not, write to the Free Software' + Cr
       + ' Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.' + Cr;

Begin

 Action(p, 'GNU General Public Licence');
 Send(p, 'GNU General Public Licence declaration:' + Cr + Cr);
 Send(p, GPL1);
 Send(p, GPL2);
 Send(p, GPL3 + Cr);
 Send(p, 'See the file "copying" in the Clusse source code and documentation' + Cr
      +  'directories for a full copy of the GPL.' + Cr);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

End.
