/* Here is the include file for the G4YFB <-> G8BPQ switch
C functions. */

#define CON_TO_NODE 1		/* connect to the node */
#define DISC	    2		/* disconnect from the node */
#define RET_TO_NODE 3           /* as 2, but return the user to the node */

/* Set the HOSTINTERRUPT to use */

extern void far set_int(int);

/* set the application flag and mask */

extern void far set_appl(int, int, int);

/* send a frame */

extern void far send_frame(int, int, int, int);

/* ack a status change */

extern void far ack_status(int);

/* set the session type */

extern void far set_session(int, int);

/* transmit a raw AX.25 frame */

extern void far raw_tx(int, int, int, int);

/* get the connected callsign */

extern void far get_call(int, int, int);

/* receive a frame, returns the length or 0 if no data available */

extern int far get_frame(int, int, int);

/* get the streams status */

extern int far get_status(int);

/* get the streams connected status */

extern int far con_status(int);

/* return the number of frames in the receive queue */

extern int far rx_queue(int);

/* return the number of frames in the transmit queue */

extern int far tx_queue(int);

/* return the number of free buffers in the switch */

extern int far free_buffs(int);

/* receive a raw AX.25 frame, return 0 if none available */

extern int far raw_rx(int, int, int);

/* get the HOSTINTERRUPT being used */

extern int far get_host(void);





